/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.utils;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class PasswordEncryptor {
    private static final int PASSWORD_RADIX = 16;

    private PasswordEncryptor() {
    }

    public static String encryptPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Password must be not null!");
        }
        byte[] buffer = new byte[password.length()];
        MessageDigest algorithm = PasswordEncryptor.getMessageDigest();
        buffer = password.getBytes();
        algorithm.update(buffer);
        byte[] digest = algorithm.digest();
        BigInteger bi = new BigInteger(digest);
        String pairLength = bi.toString(16);
        if (pairLength.length() % 2 != 0) {
            pairLength = "0" + pairLength;
        }
        return pairLength;
    }

    public static boolean areEquals(String encryptedPassword, String notEncryptedPassword) {
        String digest = PasswordEncryptor.encryptPassword(notEncryptedPassword);
        return digest.equals(encryptedPassword);
    }

    private static MessageDigest getMessageDigest() {
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        algorithm.reset();
        return algorithm;
    }
}

