/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertiesManager {
    private static final String DEFAULT_BUILD_PROPERTIES = "/build.properties";
    private static final PropertiesManager INSTANCE = new PropertiesManager();
    private static final Properties PROPERTIES = new Properties();

    private PropertiesManager() {
    }

    public static void loadProperties(Properties properties, String fileName) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        InputStream inputStream2 = inputStream = inputStream != null ? inputStream : INSTANCE.getClass().getResourceAsStream(fileName);
        if (inputStream != null) {
            properties.load(inputStream);
        }
    }

    public static void loadProperties(String fileName) throws IOException {
        InputStream inputStream = INSTANCE.getClass().getResourceAsStream(fileName);
        if (inputStream != null) {
            PROPERTIES.load(inputStream);
        }
    }

    public static String getProperty(String key) {
        return PROPERTIES.getProperty(key);
    }

    public static boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(PROPERTIES.getProperty(key));
    }

    public static Integer getIntegerProperty(String key) {
        return Integer.valueOf(PROPERTIES.getProperty(key));
    }

    public static void setProperty(String key, String value) {
        PROPERTIES.setProperty(key, value);
    }

    static {
        try {
            PropertiesManager.loadProperties(PROPERTIES, DEFAULT_BUILD_PROPERTIES);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

