/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.utils;

import com.linkare.commons.utils.StringUtils;
import java.text.Normalizer;

public final class StringNormalizer {
    private StringNormalizer() {
    }

    private static String normalize(String word, boolean toLowerCase) {
        String normalized = Normalizer.normalize(word, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        return toLowerCase ? normalized.toLowerCase() : normalized;
    }

    public static String normalize(String string) {
        return StringNormalizer.normalize(string, true);
    }

    public static String normalizePreservingCapitalizedLetters(String word) {
        return StringNormalizer.normalize(word, false);
    }

    public static void normalize(String[] words) {
        for (int i = 0; i < words.length; ++i) {
            words[i] = StringNormalizer.normalize(words[i]);
        }
    }

    public static String normalizeAndRemoveMinorChars(String word) {
        String normalizedString = StringNormalizer.normalize(word);
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : normalizedString.toCharArray()) {
            if (Character.isLowerCase(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String createComputationalName(String string) {
        return StringNormalizer.createComputationalName(string, '-');
    }

    public static String createComputationalName(String word, char separator) {
        if (StringUtils.isBlank(word)) {
            return word;
        }
        return StringNormalizer.normalizeAndRemoveMinorChars(word).replace(' ', separator).replace('/', separator);
    }
}

