package com.linkare.pointcuts;

/**
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public aspect JavaPointcuts {

    public final pointcut privateMethodCall() :
	call(private * *..*(..));

    public final pointcut protectedMethodCall() :
	call(protected * *..*(..));

    public final pointcut publicMethodCall() :
	call(public * *..*(..));

    public final pointcut packagePrivateMethodCall() :
	call(* *..*(..)) &&
	!privateMethodCall() &&
	!protectedMethodCall() &&
	!publicMethodCall();

    public pointcut methodCall() :
	privateMethodCall() ||
	packagePrivateMethodCall() ||
	protectedMethodCall() ||
	publicMethodCall();

    public final pointcut privateStaticMethodCall() :
	call(private static * *..*(..));

    public final pointcut protectedStaticMethodCall() :
	call(protected static * *..*(..));

    public final pointcut publicStaticMethodCall() :
	call(public static * *..*(..));

    public final pointcut packagePrivateStaticMethodCall() :
	call(static * *..*(..)) &&
	!privateStaticMethodCall() &&
	!protectedStaticMethodCall() &&
	!publicStaticMethodCall();

    public pointcut staticMethodCall() :
	privateStaticMethodCall() ||
	packagePrivateStaticMethodCall() ||
	protectedStaticMethodCall() ||
	publicStaticMethodCall();

    public final pointcut privateMethodExecution() :
	execution(private * *..*(..));

    public final pointcut protectedMethodExecution() :
	execution(protected * *..*(..));

    public final pointcut publicMethodExecution() :
	execution(public * *..*(..));

    public final pointcut packagePrivateMethodExecution() :
	execution(* *..*(..)) &&
	!privateMethodCall() &&
	!protectedMethodCall() &&
	!publicMethodCall();

    public pointcut methodExecution() :
	privateMethodExecution() ||
	packagePrivateMethodExecution() ||
	protectedMethodExecution() ||
	publicMethodExecution();

    public final pointcut privateStaticMethodExecution() :
	execution(private static * *..*(..));

    public final pointcut protectedStaticMethodExecution() :
	execution(protected static * *..*(..));

    public final pointcut publicStaticMethodExecution() :
	execution(public static * *..*(..));

    public final pointcut packagePrivateStaticMethodExecution() :
	execution(static * *..*(..)) &&
	!privateStaticMethodCall() &&
	!protectedStaticMethodCall() &&
	!publicStaticMethodCall();

    public pointcut staticMethodExecution() :
	privateStaticMethodExecution() ||
	packagePrivateStaticMethodExecution() ||
	protectedStaticMethodExecution() ||
	publicStaticMethodExecution();

    public pointcut privateFieldSet() :
	set(private * *);

    public pointcut protectedFieldSet() :
	set(protected * *);

    public pointcut publicFieldSet() :
	set(public * *);

    public pointcut packagePrivateFieldSet() :
	set(* *) &&
	!privateFieldSet() &&
	!protectedFieldSet() &&
	!publicFieldSet();

    public pointcut fieldSet() :
	privateFieldSet() ||
	packagePrivateFieldSet() ||
	protectedFieldSet() ||
	publicFieldSet();

    public pointcut privateFinalFieldSet() :
	set(private final * *);

    public pointcut protectedFinalFieldSet() :
	set(protected final * *);

    public pointcut publicFinalFieldSet() :
	set(public final * *);

    public pointcut packagePrivateFinalFieldSet() :
	set(final * *) &&
	!privateFinalFieldSet() &&
	!protectedFinalFieldSet() &&
	!publicFinalFieldSet();

    public pointcut finalFieldSet() :
	privateFinalFieldSet() ||
	packagePrivateFinalFieldSet() ||
	protectedFinalFieldSet() ||
	publicFinalFieldSet();

    public pointcut privateStaticFieldSet() :
	set(private static * *);

    public pointcut protectedStaticFieldSet() :
	set(protected static * *);

    public pointcut publicStaticFieldSet() :
	set(private static * *);

    public pointcut packagePrivateStaticFieldSet() :
	set(static * *) &&
	!privateStaticFieldSet() &&
	!protectedStaticFieldSet() &&
	!publicStaticFieldSet();

    public pointcut staticFieldSet() :
	privateStaticFieldSet() ||
	packagePrivateStaticFieldSet() ||
	protectedStaticFieldSet() ||
	publicStaticFieldSet();

    public pointcut privateStaticFinalFieldSet() :
	set(private static final * *);

    public pointcut protectedStaticFinalFieldSet() :
	set(protected static final * *);

    public pointcut publicStaticFinalFieldSet() :
	set(private static final * *);

    public pointcut packagePrivateStaticFinalFieldSet() :
	set(static final * *) &&
	!privateStaticFinalFieldSet() &&
	!protectedStaticFinalFieldSet() &&
	!publicStaticFinalFieldSet();

    public pointcut staticFinalFieldSet() :
	privateStaticFinalFieldSet() ||
	packagePrivateStaticFinalFieldSet() ||
	protectedStaticFinalFieldSet() ||
	publicStaticFinalFieldSet();
    
    public pointcut privateFieldGet() :
	get(private * *);

    public pointcut protectedFieldGet() :
	get(protected * *);

    public pointcut publicFieldGet() :
	get(public * *);

    public pointcut packagePrivateFieldGet() :
	get(* *) &&
	!privateFieldGet() &&
	!protectedFieldGet() &&
	!publicFieldGet();

    public pointcut fieldGet() :
	privateFieldGet() ||
	packagePrivateFieldGet() ||
	protectedFieldGet() ||
	publicFieldGet();

    public pointcut privateFinalFieldGet() :
	get(private final * *);

    public pointcut protectedFinalFieldGet() :
	get(protected final * *);

    public pointcut publicFinalFieldGet() :
	get(public final * *);

    public pointcut packagePrivateFinalFieldGet() :
	get(final * *) &&
	!privateFinalFieldGet() &&
	!protectedFinalFieldGet() &&
	!publicFinalFieldGet();

    public pointcut finalFieldGet() :
	privateFinalFieldGet() ||
	packagePrivateFinalFieldGet() ||
	protectedFinalFieldGet() ||
	publicFinalFieldGet();

    public pointcut privateStaticFieldGet() :
	get(private static * *);

    public pointcut protectedStaticFieldGet() :
	get(protected static * *);

    public pointcut publicStaticFieldGet() :
	get(private static * *);

    public pointcut packagePrivateStaticFieldGet() :
	get(static * *) &&
	!privateStaticFieldGet() &&
	!protectedStaticFieldGet() &&
	!publicStaticFieldGet();

    public pointcut staticFieldGet() :
	privateStaticFieldGet() ||
	packagePrivateStaticFieldGet() ||
	protectedStaticFieldGet() ||
	publicStaticFieldGet();

    public pointcut privateStaticFinalFieldGet() :
	get(private static final * *);

    public pointcut protectedStaticFinalFieldGet() :
	get(protected static final * *);

    public pointcut publicStaticFinalFieldGet() :
	get(private static final * *);
    
    public pointcut packagePrivateStaticFinalFieldGet() :
	get(static final * *) &&
	!privateStaticFinalFieldGet() &&
	!protectedStaticFinalFieldGet() &&
	!publicStaticFinalFieldGet();

    public pointcut staticFinalFieldGet() :
	privateStaticFinalFieldGet() ||
	packagePrivateStaticFinalFieldGet() ||
	protectedStaticFinalFieldGet() ||
	publicStaticFinalFieldGet();

    public final pointcut privateConstructorCall() :
	call(private *..*.new(..));

    public final pointcut protectedConstructorCall() :
	call(protected *..*.new(..));

    public final pointcut publicConstructorCall() :
	call(public *..*.new(..));

    public final pointcut packagePrivateConstructorCall() :
	call(*..*.new(..)) &&
	!privateConstructorCall() &&
	!protectedConstructorCall() &&
	!publicConstructorCall();

    public pointcut constructorCall() :
	privateConstructorCall() ||
	packagePrivateConstructorCall() ||
	protectedConstructorCall() ||
	publicConstructorCall();

    public final pointcut privateConstructorExecution() :
	execution(private *..*.new(..));

    public final pointcut protectedConstructorExecution() :
	execution(protected *..*.new(..));

    public final pointcut publicConstructorExecution() :
	execution(public *..*.new(..));

    public final pointcut packagePrivateConstructorExecution() :
	execution(*..*.new(..)) &&
	!privateConstructorExecution() &&
	!protectedConstructorExecution() &&
	!publicConstructorExecution();

    public pointcut constructorExecution() :
	privateConstructorExecution() ||
	packagePrivateConstructorExecution() ||
	protectedConstructorExecution() ||
	publicConstructorExecution();
    
    public pointcut privateClassInitialization() :
	initialization(private *..*.new(..));

    public pointcut protectedClassInitialization() :
	initialization(protected *..*.new(..));

    public pointcut publicClassInitialization() :
	initialization(public *..*.new(..));

    public pointcut packagePrivateClassInitialization() :
	initialization(*..*.new(..)) &&
	!privateClassInitialization() &&
	!protectedClassInitialization() &&
	!publicClassInitialization();

    public pointcut classInitialization() :
	privateClassInitialization() ||
	packagePrivateClassInitialization() ||
	protectedClassInitialization() ||
	publicClassInitialization();

    public pointcut privateClassStaticInitialization() :
	initialization(private static *..*.new(..));

    public pointcut protectedClassStaticInitialization() :
	initialization(protected static *..*.new(..));

    public pointcut publicClassStaticInitialization() :
	initialization(public static *..*.new(..));

    public pointcut packagePrivateClassStaticInitialization() :
	initialization(static *..*.new(..)) &&
	!privateClassStaticInitialization() &&
	!protectedClassStaticInitialization() &&
	!publicClassStaticInitialization();

    public pointcut classStaticInitialization() :
	privateClassStaticInitialization() ||
	packagePrivateClassStaticInitialization() ||
	protectedClassStaticInitialization() ||
	publicClassStaticInitialization();
}