package com.linkare.pointcuts;

/**
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public aspect SwingPointcuts {

    public pointcut threadSafeCall() :
	call(void javax.swing.JComponent.revalidate()) ||
	call(void javax.swing.JComponent.repaint(..)) ||
	call(void java.awt.Component.invalidate()) ||
	call(void add*Listener(java.util.EventListener+)) ||
	call(void remove*Listener(java.util.EventListener+));

    public pointcut viewCall() :
	call(void javax..JComponent+.*(..)) ||
	call(void javax..JFrame.*(..));

    public pointcut modelCall() :
	call(void javax..*Model+.*(..)) ||
	call(void javax.swing.text.Document+.*(..));

    public pointcut uiCall() :
	viewCall() || modelCall();
    
    public pointcut setVisibleCall(final boolean visible) :
	uiCall() && call(public void java.awt.Window.setVisible(boolean)) && args(visible);
}