/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import ch.lambdaj.collection.LambdaCollections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import redis.clients.jedis.Jedis;

public class EmbeddedRedisInstances {
    private static EmbeddedRedisInstances embeddedInstances;
    private Map<String, Jedis> instances = new HashMap<String, Jedis>();

    private EmbeddedRedisInstances() {
    }

    public static synchronized EmbeddedRedisInstances getInstance() {
        if (embeddedInstances == null) {
            embeddedInstances = new EmbeddedRedisInstances();
        }
        return embeddedInstances;
    }

    public void addJedis(Jedis jedis, String targetPath) {
        this.instances.put(targetPath, jedis);
    }

    public void removeJedis(String targetPath) {
        this.instances.remove(targetPath);
    }

    public Jedis getJedisByTargetPath(String targetPath) {
        return this.instances.get(targetPath);
    }

    public Jedis getDefaultJedis() {
        return (Jedis)LambdaCollections.with(this.instances).values().first(CoreMatchers.anything());
    }
}

