/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.replication;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.redis.ManagedRedisLifecycleManager;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ReplicationGroup {
    private static final int MASTER_SERVER = 1;
    private final ManagedRedisLifecycleManager master;
    private List<ManagedRedisLifecycleManager> slaveServers = new LinkedList<ManagedRedisLifecycleManager>();

    public ReplicationGroup(ManagedRedisLifecycleManager managedRedisLifecycleManager) {
        this.master = managedRedisLifecycleManager;
    }

    public void addSlaveServer(ManagedRedisLifecycleManager managedRedisLifecycleManager) {
        this.slaveServers.add(managedRedisLifecycleManager);
    }

    protected List<ManagedRedisLifecycleManager> getSlaveServers() {
        return this.slaveServers;
    }

    protected ManagedRedisLifecycleManager getMaster() {
        return this.master;
    }

    public ManagedRedisLifecycleManager getStoppedServer(int port) {
        if (this.master.getPort() == port && !this.master.isReady()) {
            return this.master;
        }
        return (ManagedRedisLifecycleManager)((Object)Lambda.selectFirst(this.slaveServers, (Matcher)Lambda.having((Object)((ManagedRedisLifecycleManager)((Object)Lambda.on(ManagedRedisLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedRedisLifecycleManager)((Object)Lambda.on(ManagedRedisLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)false)))));
    }

    public ManagedRedisLifecycleManager getStartedServer(int port) {
        if (this.master.getPort() == port && this.master.isReady()) {
            return this.master;
        }
        return (ManagedRedisLifecycleManager)((Object)Lambda.selectFirst(this.slaveServers, (Matcher)Lambda.having((Object)((ManagedRedisLifecycleManager)((Object)Lambda.on(ManagedRedisLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedRedisLifecycleManager)((Object)Lambda.on(ManagedRedisLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)true)))));
    }

    public int numberOfStartedServers() {
        return this.slaveServers.size() + 1 - this.numberOfStoppedServers();
    }

    public int numberOfStoppedServers() {
        int numberOfStoppedServers = 0;
        if (!this.master.isReady()) {
            ++numberOfStoppedServers;
        }
        for (ManagedRedisLifecycleManager managedRedisLifecycleManager : this.slaveServers) {
            if (managedRedisLifecycleManager.isReady()) continue;
            ++numberOfStoppedServers;
        }
        return numberOfStoppedServers;
    }
}

