/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.PackIndexWriter;
import org.eclipse.jgit.storage.pack.BaseSearch;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.DeltaIndex;
import org.eclipse.jgit.storage.pack.DeltaTask;
import org.eclipse.jgit.storage.pack.DeltaWindow;
import org.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.storage.pack.ThreadSafeDeltaCache;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackWriter {
    private static final int PACK_VERSION_GENERATED = 2;
    private final BlockList<ObjectToPack>[] objectsLists = new BlockList[5];
    private final ObjectIdOwnerMap<ObjectToPack> objectsMap;
    private List<ObjectToPack> edgeObjects;
    private List<CachedPack> cachedPacks;
    private Set<ObjectId> tagTargets;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    private final PackConfig config;
    private final Statistics stats;
    private Statistics.ObjectType typeStats;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean deltaBaseAsOffset;
    private boolean reuseDeltas;
    private boolean reuseDeltaCommits;
    private boolean reuseValidate;
    private boolean thin;
    private boolean useCachedPacks;
    private boolean ignoreMissingUninteresting;
    private boolean pruneCurrentObjectList;

    public PackWriter(Repository repo) {
        this(repo, repo.newObjectReader());
    }

    public PackWriter(ObjectReader reader) {
        this(new PackConfig(), reader);
    }

    public PackWriter(Repository repo, ObjectReader reader) {
        this(new PackConfig(repo), reader);
    }

    public PackWriter(PackConfig config, ObjectReader reader) {
        this.objectsLists[1] = new BlockList();
        this.objectsLists[2] = new BlockList();
        this.objectsLists[3] = new BlockList();
        this.objectsLists[4] = new BlockList();
        this.objectsMap = new ObjectIdOwnerMap();
        this.edgeObjects = new BlockList<ObjectToPack>();
        this.cachedPacks = new ArrayList<CachedPack>(2);
        this.tagTargets = Collections.emptySet();
        this.ignoreMissingUninteresting = true;
        this.config = config;
        this.reader = reader;
        this.reuseSupport = reader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)reader) : null;
        this.deltaBaseAsOffset = config.isDeltaBaseAsOffset();
        this.reuseDeltas = config.isReuseDeltas();
        this.reuseValidate = true;
        this.stats = new Statistics();
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isReuseDeltaCommits() {
        return this.reuseDeltaCommits;
    }

    public void setReuseDeltaCommits(boolean reuse) {
        this.reuseDeltaCommits = reuse;
    }

    public boolean isReuseValidatingObjects() {
        return this.reuseValidate;
    }

    public void setReuseValidatingObjects(boolean validate) {
        this.reuseValidate = validate;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean packthin) {
        this.thin = packthin;
    }

    public boolean isUseCachedPacks() {
        return this.useCachedPacks;
    }

    public void setUseCachedPacks(boolean useCached) {
        this.useCachedPacks = useCached;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean ignore) {
        this.ignoreMissingUninteresting = ignore;
    }

    public void setTagTargets(Set<ObjectId> objects) {
        this.tagTargets = objects;
    }

    public long getObjectCount() throws IOException {
        if (this.stats.totalObjects == 0L) {
            long objCnt = 0L;
            objCnt += (long)this.objectsLists[1].size();
            objCnt += (long)this.objectsLists[2].size();
            objCnt += (long)this.objectsLists[3].size();
            objCnt += (long)this.objectsLists[4].size();
            for (CachedPack pack : this.cachedPacks) {
                objCnt += pack.getObjectCount();
            }
            return objCnt;
        }
        return this.stats.totalObjects;
    }

    public void preparePack(Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    public void preparePack(ProgressMonitor countingMonitor, Collection<? extends ObjectId> want, Collection<? extends ObjectId> have) throws IOException {
        ObjectWalk ow = new ObjectWalk(this.reader);
        this.preparePack(countingMonitor, ow, want, have);
    }

    public void preparePack(ProgressMonitor countingMonitor, ObjectWalk walk, Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects) throws IOException {
        if (countingMonitor == null) {
            countingMonitor = NullProgressMonitor.INSTANCE;
        }
        this.findObjectsToPack(countingMonitor, walk, interestingObjects, uninterestingObjects);
    }

    public boolean willInclude(AnyObjectId id) throws IOException {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge();
    }

    public ObjectToPack get(AnyObjectId id) {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge() ? obj : null;
    }

    public ObjectId computeName() {
        byte[] buf = new byte[20];
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        if (!this.cachedPacks.isEmpty()) {
            throw new IOException(JGitText.get().cachedPacksPreventsIndexCreation);
        }
        List<ObjectToPack> list = this.sortByName();
        int indexVersion = this.config.getIndexVersion();
        PackIndexWriter iw = indexVersion <= 0 ? PackIndexWriter.createOldestPossible(indexStream, list) : PackIndexWriter.createVersion(indexStream, indexVersion);
        iw.write(list, this.packcsum);
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            int cnt = 0;
            cnt += this.objectsLists[1].size();
            cnt += this.objectsLists[2].size();
            cnt += this.objectsLists[3].size();
            this.sortedByName = new BlockList<ObjectToPack>(cnt += this.objectsLists[4].size());
            this.sortedByName.addAll(this.objectsLists[1]);
            this.sortedByName.addAll(this.objectsLists[2]);
            this.sortedByName.addAll(this.objectsLists[3]);
            this.sortedByName.addAll(this.objectsLists[4]);
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    public void writePack(ProgressMonitor compressMonitor, ProgressMonitor writeMonitor, OutputStream packStream) throws IOException {
        long objCnt;
        boolean needSearchForReuse;
        if (compressMonitor == null) {
            compressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (writeMonitor == null) {
            writeMonitor = NullProgressMonitor.INSTANCE;
        }
        boolean bl = needSearchForReuse = this.reuseSupport != null && (this.reuseDeltas || this.config.isReuseObjects() || !this.cachedPacks.isEmpty());
        if (compressMonitor instanceof BatchingProgressMonitor) {
            long delay = 1000L;
            if (needSearchForReuse && this.config.isDeltaCompress()) {
                delay = 500L;
            }
            ((BatchingProgressMonitor)compressMonitor).setDelayStart(delay, TimeUnit.MILLISECONDS);
        }
        if (needSearchForReuse) {
            this.searchForReuse(compressMonitor);
        }
        if (this.config.isDeltaCompress()) {
            this.searchForDeltas(compressMonitor);
        }
        PackOutputStream out = new PackOutputStream(writeMonitor, packStream, this);
        this.stats.totalObjects = objCnt = this.getObjectCount();
        writeMonitor.beginTask(JGitText.get().writingObjects, (int)objCnt);
        long writeStart = System.currentTimeMillis();
        out.writeFileHeader(2, objCnt);
        out.flush();
        this.writeObjects(out);
        if (!this.edgeObjects.isEmpty() || !this.cachedPacks.isEmpty()) {
            for (Statistics.ObjectType typeStat : this.stats.objectTypes) {
                if (typeStat == null) continue;
                this.stats.thinPackBytes += typeStat.bytes;
            }
        }
        for (CachedPack pack : this.cachedPacks) {
            long deltaCnt = pack.getDeltaCount();
            this.stats.reusedObjects += pack.getObjectCount();
            this.stats.reusedDeltas += deltaCnt;
            this.stats.totalDeltas += deltaCnt;
            this.reuseSupport.copyPackAsIs(out, pack, this.reuseValidate);
        }
        this.writeChecksum(out);
        out.flush();
        this.stats.timeWriting = System.currentTimeMillis() - writeStart;
        this.stats.totalBytes = out.length();
        this.stats.reusedPacks = Collections.unmodifiableList(this.cachedPacks);
        for (Statistics.ObjectType typeStat : this.stats.objectTypes) {
            if (typeStat == null) continue;
            typeStat.cntDeltas += typeStat.reusedDeltas;
            this.stats.reusedObjects += typeStat.reusedObjects;
            this.stats.reusedDeltas += typeStat.reusedDeltas;
            this.stats.totalDeltas += typeStat.cntDeltas;
        }
        this.reader.release();
        writeMonitor.endTask();
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public void release() {
        this.reader.release();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
    }

    private void searchForReuse(ProgressMonitor monitor) throws IOException {
        int cnt = 0;
        cnt += this.objectsLists[1].size();
        cnt += this.objectsLists[2].size();
        cnt += this.objectsLists[3].size();
        long start = System.currentTimeMillis();
        monitor.beginTask(JGitText.get().searchForReuse, cnt += this.objectsLists[4].size());
        if (cnt <= 4096) {
            BlockList<ObjectToPack> tmp = new BlockList<ObjectToPack>(cnt);
            tmp.addAll(this.objectsLists[1]);
            tmp.addAll(this.objectsLists[2]);
            tmp.addAll(this.objectsLists[3]);
            tmp.addAll(this.objectsLists[4]);
            this.searchForReuse(monitor, tmp);
            if (this.pruneCurrentObjectList) {
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[1]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[2]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[3]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[4]);
            }
        } else {
            this.searchForReuse(monitor, this.objectsLists[1]);
            this.searchForReuse(monitor, this.objectsLists[2]);
            this.searchForReuse(monitor, this.objectsLists[3]);
            this.searchForReuse(monitor, this.objectsLists[4]);
        }
        monitor.endTask();
        this.stats.timeSearchingForReuse = System.currentTimeMillis() - start;
    }

    private void searchForReuse(ProgressMonitor monitor, List<ObjectToPack> list) throws IOException, MissingObjectException {
        this.pruneCurrentObjectList = false;
        this.reuseSupport.selectObjectRepresentation(this, monitor, list);
        if (this.pruneCurrentObjectList) {
            PackWriter.pruneEdgesFromObjectList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectToPack[] list = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int cnt = 0;
        cnt = this.findObjectsNeedingDelta(list, cnt, 2);
        if ((cnt = this.findObjectsNeedingDelta(list, cnt, 3)) == 0) {
            return;
        }
        int nonEdgeCnt = cnt;
        for (ObjectToPack eo : this.edgeObjects) {
            eo.setWeight(0);
            list[cnt++] = eo;
        }
        long sizingStart = System.currentTimeMillis();
        monitor.beginTask(JGitText.get().searchForSizes, cnt);
        AsyncObjectSizeQueue<ObjectToPack> sizeQueue = this.reader.getObjectSize(Arrays.asList(list).subList(0, cnt), false);
        try {
            long limit = this.config.getBigFileThreshold();
            while (true) {
                long sz;
                monitor.update(1);
                try {
                    if (!sizeQueue.next()) {
                        break;
                    }
                }
                catch (MissingObjectException notFound) {
                    if (this.ignoreMissingUninteresting) {
                        ObjectToPack otp = sizeQueue.getCurrent();
                        if (otp != null && otp.isEdge()) {
                            otp.setDoNotDelta(true);
                            continue;
                        }
                        otp = this.objectsMap.get(notFound.getObjectId());
                        if (otp != null && otp.isEdge()) {
                            otp.setDoNotDelta(true);
                            continue;
                        }
                    }
                    throw notFound;
                }
                ObjectToPack otp = sizeQueue.getCurrent();
                if (otp == null) {
                    otp = this.objectsMap.get(sizeQueue.getObjectId());
                }
                if (limit <= (sz = sizeQueue.getSize()) || Integer.MAX_VALUE <= sz) {
                    otp.setDoNotDelta(true);
                    continue;
                }
                if (sz <= 16L) {
                    otp.setDoNotDelta(true);
                    continue;
                }
                otp.setWeight((int)sz);
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            sizeQueue.release();
            throw throwable;
        }
        sizeQueue.release();
        monitor.endTask();
        this.stats.timeSearchingForSizes = System.currentTimeMillis() - sizingStart;
        Arrays.sort(list, 0, cnt, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                int cmp = (a.isDoNotDelta() ? 1 : 0) - (b.isDoNotDelta() ? 1 : 0);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getType() - b.getType();
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() >>> 1) - (b.getPathHash() >>> 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() & 1) - (b.getPathHash() & 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.isEdge() ? 0 : 1) - (b.isEdge() ? 0 : 1);
                if (cmp != 0) {
                    return cmp;
                }
                return b.getWeight() - a.getWeight();
            }
        });
        while (0 < cnt && list[cnt - 1].isDoNotDelta()) {
            if (!list[cnt - 1].isEdge()) {
                --nonEdgeCnt;
            }
            --cnt;
        }
        if (cnt == 0) {
            return;
        }
        long searchStart = System.currentTimeMillis();
        monitor.beginTask(JGitText.get().compressingObjects, nonEdgeCnt);
        this.searchForDeltas(monitor, list, cnt);
        monitor.endTask();
        this.stats.deltaSearchNonEdgeObjects = nonEdgeCnt;
        this.stats.timeCompressing = System.currentTimeMillis() - searchStart;
        for (int i = 0; i < cnt; ++i) {
            if (list[i].isEdge() || !list[i].isDeltaRepresentation()) continue;
            ++this.stats.deltasFound;
        }
    }

    private int findObjectsNeedingDelta(ObjectToPack[] list, int cnt, int type) {
        for (ObjectToPack otp : this.objectsLists[type]) {
            if (otp.isReuseAsIs() || otp.isDoNotDelta()) continue;
            otp.setWeight(0);
            list[cnt++] = otp;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void searchForDeltas(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws MissingObjectException, IncorrectObjectTypeException, LargeObjectException, IOException {
        int batchSize;
        int threads = this.config.getThreads();
        if (threads == 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        if (threads <= 1 || cnt <= 2 * this.config.getDeltaSearchWindowSize()) {
            DeltaCache dc = new DeltaCache(this.config);
            DeltaWindow dw = new DeltaWindow(this.config, dc, this.reader);
            dw.search(monitor, list, 0, cnt);
            return;
        }
        ThreadSafeDeltaCache dc = new ThreadSafeDeltaCache(this.config);
        ThreadSafeProgressMonitor pm = new ThreadSafeProgressMonitor(monitor);
        int estSize = cnt / (threads * 2);
        if (estSize < 2 * this.config.getDeltaSearchWindowSize()) {
            estSize = 2 * this.config.getDeltaSearchWindowSize();
        }
        ArrayList<DeltaTask> myTasks = new ArrayList<DeltaTask>(threads * 2);
        for (int i = 0; i < cnt; i += batchSize) {
            int start = i;
            if (cnt - i < estSize) {
                batchSize = cnt - i;
            } else {
                int end;
                for (end = start + estSize; end < cnt; ++end) {
                    ObjectToPack a = list[end - 1];
                    ObjectToPack b = list[end];
                    if (a.getPathHash() != b.getPathHash()) break;
                }
                batchSize = end - start;
            }
            myTasks.add(new DeltaTask(this.config, this.reader, dc, pm, batchSize, start, list));
        }
        pm.startWorkers(myTasks.size());
        Executor executor = this.config.getExecutor();
        final List<Throwable> errors = Collections.synchronizedList(new ArrayList());
        if (executor instanceof ExecutorService) {
            this.runTasks((ExecutorService)executor, pm, myTasks, errors);
        } else {
            if (executor == null) {
                ExecutorService pool = Executors.newFixedThreadPool(threads);
                this.runTasks(pool, pm, myTasks, errors);
                Object var16_27 = null;
                pool.shutdown();
                try {
                    while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
                catch (Throwable throwable) {
                    Object var16_28 = null;
                    pool.shutdown();
                    try {
                        while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        }
                    }
                    catch (InterruptedException e) {
                        throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                    }
                }
                throw throwable;
            }
            for (final DeltaTask task : myTasks) {
                executor.execute(new Runnable(){

                    public void run() {
                        try {
                            task.call();
                        }
                        catch (Throwable failure) {
                            errors.add(failure);
                        }
                    }
                });
            }
            try {
                pm.waitForCompletion();
            }
            catch (InterruptedException ie) {
                throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
            }
        }
        if (!errors.isEmpty()) {
            Throwable err = errors.get(0);
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            IOException fail = new IOException(err.getMessage());
            fail.initCause(err);
            throw fail;
        }
    }

    private void runTasks(ExecutorService pool, ThreadSafeProgressMonitor pm, List<DeltaTask> tasks, List<Throwable> errors) throws IOException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tasks.size());
        for (DeltaTask deltaTask : tasks) {
            futures.add(pool.submit(deltaTask));
        }
        try {
            pm.waitForCompletion();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    errors.add(executionException.getCause());
                }
            }
        }
        catch (InterruptedException ie) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
        }
    }

    private void writeObjects(PackOutputStream out) throws IOException {
        this.writeObjects(out, this.objectsLists[1]);
        this.writeObjects(out, this.objectsLists[4]);
        this.writeObjects(out, this.objectsLists[2]);
        this.writeObjects(out, this.objectsLists[3]);
    }

    private void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.typeStats = this.stats.objectTypes[list.get(0).getType()];
        long beginOffset = out.length();
        if (this.reuseSupport != null) {
            this.reuseSupport.writeObjects(out, list);
        } else {
            for (ObjectToPack otp : list) {
                out.writeObject(otp);
            }
        }
        this.typeStats.bytes += out.length() - beginOffset;
        this.typeStats.cntObjects = list.size();
    }

    void writeObject(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (!otp.isWritten()) {
            this.writeObjectImpl(out, otp);
        }
    }

    private void writeObjectImpl(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (otp.wantWrite()) {
            this.reuseDeltas = false;
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
            this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
        }
        otp.markWantWrite();
        while (otp.isReuseAsIs()) {
            this.writeBase(out, otp.getDeltaBase());
            if (otp.isWritten()) {
                return;
            }
            out.resetCRC32();
            otp.setOffset(out.length());
            try {
                this.reuseSupport.copyObjectAsIs(out, otp, this.reuseValidate);
                out.endObject();
                otp.setCRC(out.getCRC32());
                ++this.typeStats.reusedObjects;
                if (otp.isDeltaRepresentation()) {
                    ++this.typeStats.reusedDeltas;
                    this.typeStats.deltaBytes += out.length() - otp.getOffset();
                }
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException gone) {
                if (otp.getOffset() == out.length()) {
                    otp.setOffset(0L);
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
                    continue;
                }
                CorruptObjectException coe = new CorruptObjectException(otp, "");
                coe.initCause(gone);
                throw coe;
            }
        }
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(out, otp);
        } else {
            this.writeWholeObjectDeflate(out, otp);
        }
        out.endObject();
        otp.setCRC(out.getCRC32());
    }

    private void writeBase(PackOutputStream out, ObjectToPack baseInPack) throws IOException {
        if (baseInPack != null && !baseInPack.isWritten()) {
            this.writeObjectImpl(out, baseInPack);
        }
    }

    private void writeWholeObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        Deflater deflater = this.deflater();
        ObjectLoader ldr = this.reader.open(otp, otp.getType());
        out.resetCRC32();
        otp.setOffset(out.length());
        out.writeHeader(otp, ldr.getSize());
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        ldr.copyTo(dst);
        dst.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        byte[] zbuf;
        this.writeBase(out, otp.getDeltaBase());
        out.resetCRC32();
        otp.setOffset(out.length());
        DeltaCache.Ref ref = otp.popCachedDelta();
        if (ref != null && (zbuf = (byte[])ref.get()) != null) {
            out.writeHeader(otp, otp.getCachedSize());
            out.write(zbuf);
            return;
        }
        TemporaryBuffer.Heap delta = this.delta(otp);
        out.writeHeader(otp, delta.length());
        Deflater deflater = this.deflater();
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        delta.writeTo(dst, null);
        dst.finish();
        ++this.typeStats.cntDeltas;
        this.typeStats.deltaBytes += out.length() - otp.getOffset();
    }

    private TemporaryBuffer.Heap delta(ObjectToPack otp) throws IOException {
        DeltaIndex index = new DeltaIndex(this.buffer(otp.getDeltaBaseId()));
        byte[] res = this.buffer(otp);
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(res.length);
        index.encode(delta, res);
        return delta;
    }

    private byte[] buffer(AnyObjectId objId) throws IOException {
        return PackWriter.buffer(this.config, this.reader, objId);
    }

    static byte[] buffer(PackConfig config, ObjectReader or, AnyObjectId objId) throws IOException {
        return or.open(objId).getCachedBytes(config.getBigFileThreshold());
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.config.getCompressionLevel());
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream out) throws IOException {
        this.packcsum = out.getDigest();
        out.write(this.packcsum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findObjectsToPack(ProgressMonitor countingMonitor, ObjectWalk walker, Collection<? extends ObjectId> want, Collection<? extends ObjectId> have) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        RevObject o;
        RevCommit c;
        long countingStart = System.currentTimeMillis();
        countingMonitor.beginTask(JGitText.get().countingObjects, 0);
        if (have == null) {
            have = Collections.emptySet();
        }
        this.stats.interestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(want));
        this.stats.uninterestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(have));
        ArrayList<ObjectId> all = new ArrayList<ObjectId>(want.size() + have.size());
        all.addAll(want);
        all.addAll(have);
        HashMap<ObjectId, CachedPack> tipToPack = new HashMap<ObjectId, CachedPack>();
        RevFlag inCachedPack = walker.newFlag("inCachedPack");
        RevFlag include = walker.newFlag("include");
        RevFlag added = walker.newFlag("added");
        RevFlagSet keepOnRestart = new RevFlagSet();
        keepOnRestart.add(inCachedPack);
        walker.setRetainBody(false);
        walker.carry(include);
        int haveEst = have.size();
        if (have.isEmpty()) {
            walker.sort(RevSort.COMMIT_TIME_DESC);
            if (this.useCachedPacks && this.reuseSupport != null) {
                HashSet<? extends ObjectId> need = new HashSet<ObjectId>(want);
                LinkedList<CachedPack> shortCircuit = new LinkedList<CachedPack>();
                for (CachedPack pack : this.reuseSupport.getCachedPacks()) {
                    if (need.containsAll(pack.getTips())) {
                        need.removeAll(pack.getTips());
                        shortCircuit.add(pack);
                    }
                    for (ObjectId id : pack.getTips()) {
                        tipToPack.put(id, pack);
                        all.add(id);
                    }
                }
                if (need.isEmpty() && !shortCircuit.isEmpty()) {
                    this.cachedPacks.addAll(shortCircuit);
                    for (CachedPack pack : shortCircuit) {
                        countingMonitor.update((int)pack.getObjectCount());
                    }
                    countingMonitor.endTask();
                    this.stats.timeCounting = System.currentTimeMillis() - countingStart;
                    return;
                }
                haveEst += tipToPack.size();
            }
        } else {
            walker.sort(RevSort.TOPO);
            if (this.thin) {
                walker.sort(RevSort.BOUNDARY, true);
            }
        }
        ArrayList<RevObject> wantObjs = new ArrayList<RevObject>(want.size());
        ArrayList<RevObject> haveObjs = new ArrayList<RevObject>(haveEst);
        ArrayList<RevTag> wantTags = new ArrayList<RevTag>(want.size());
        AsyncRevObjectQueue q = walker.parseAny(all, true);
        try {
            while (true) {
                try {
                    RevObject o2;
                    while ((o2 = q.next()) != null) {
                        if (tipToPack.containsKey(o2)) {
                            o2.add(inCachedPack);
                        }
                        if (have.contains(o2)) {
                            haveObjs.add(o2);
                            continue;
                        }
                        if (!want.contains(o2)) continue;
                        o2.add(include);
                        wantObjs.add(o2);
                        if (!(o2 instanceof RevTag)) continue;
                        wantTags.add((RevTag)o2);
                    }
                }
                catch (MissingObjectException e) {
                    if (this.ignoreMissingUninteresting && have.contains(e.getObjectId())) continue;
                    throw e;
                }
                break;
            }
            Object var21_21 = null;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            q.release();
            throw throwable;
        }
        q.release();
        if (!wantTags.isEmpty()) {
            all = new ArrayList(wantTags.size());
            for (RevTag tag : wantTags) {
                all.add(tag.getObject());
            }
            q = walker.parseAny(all, true);
            try {
                while (q.next() != null) {
                }
                Object var23_25 = null;
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                q.release();
                throw throwable;
            }
            q.release();
            {
            }
        }
        for (RevObject obj : wantObjs) {
            walker.markStart(obj);
        }
        for (RevObject obj : haveObjs) {
            walker.markUninteresting(obj);
        }
        int maxBases = this.config.getDeltaSearchWindowSize();
        HashSet<RevTree> baseTrees = new HashSet<RevTree>();
        BlockList<RevCommit> commits = new BlockList<RevCommit>();
        while ((c = walker.next()) != null) {
            CachedPack pack;
            if (c.has(inCachedPack) && PackWriter.includesAllTips(pack = (CachedPack)tipToPack.get(c), include, walker)) {
                this.useCachedPack(walker, keepOnRestart, wantObjs, haveObjs, pack);
                commits = new BlockList();
                countingMonitor.endTask();
                countingMonitor.beginTask(JGitText.get().countingObjects, 0);
                continue;
            }
            if (c.has(RevFlag.UNINTERESTING)) {
                if (baseTrees.size() > maxBases) continue;
                baseTrees.add(c.getTree());
                continue;
            }
            commits.add(c);
            countingMonitor.update(1);
        }
        int commitCnt = 0;
        boolean putTagTargets = false;
        for (RevCommit cmit : commits) {
            if (!cmit.has(added)) {
                cmit.add(added);
                this.addObject(cmit, 0);
                ++commitCnt;
            }
            for (int i = 0; i < cmit.getParentCount(); ++i) {
                RevCommit p = cmit.getParent(i);
                if (p.has(added) || p.has(RevFlag.UNINTERESTING)) continue;
                p.add(added);
                this.addObject(p, 0);
                ++commitCnt;
            }
            if (putTagTargets || 4096 >= commitCnt) continue;
            for (ObjectId id : this.tagTargets) {
                RevObject obj = walker.lookupOrNull(id);
                if (!(obj instanceof RevCommit) || !obj.has(include) || obj.has(RevFlag.UNINTERESTING) || obj.has(added)) continue;
                obj.add(added);
                this.addObject(obj, 0);
            }
            putTagTargets = true;
        }
        commits = null;
        BaseSearch bases = new BaseSearch(countingMonitor, baseTrees, this.objectsMap, this.edgeObjects, this.reader);
        while ((o = walker.nextObject()) != null) {
            if (o.has(RevFlag.UNINTERESTING)) continue;
            int pathHash = walker.getPathHashCode();
            byte[] pathBuf = walker.getPathBuffer();
            int pathLen = walker.getPathLength();
            bases.addBase(o.getType(), pathBuf, pathLen, pathHash);
            this.addObject(o, pathHash);
            countingMonitor.update(1);
        }
        for (CachedPack pack : this.cachedPacks) {
            countingMonitor.update((int)pack.getObjectCount());
        }
        countingMonitor.endTask();
        this.stats.timeCounting = System.currentTimeMillis() - countingStart;
    }

    private static void pruneEdgesFromObjectList(List<ObjectToPack> list) {
        int size = list.size();
        int dst = 0;
        for (int src = 0; src < size; ++src) {
            ObjectToPack obj = list.get(src);
            if (obj.isEdge()) continue;
            if (dst != src) {
                list.set(dst, obj);
            }
            ++dst;
        }
        while (dst < list.size()) {
            list.remove(list.size() - 1);
        }
    }

    private void useCachedPack(ObjectWalk walker, RevFlagSet keepOnRestart, List<RevObject> wantObj, List<RevObject> baseObj, CachedPack pack) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.cachedPacks.add(pack);
        for (ObjectId objectId : pack.getTips()) {
            baseObj.add(walker.lookupOrNull(objectId));
        }
        this.setThin(true);
        walker.resetRetain(keepOnRestart);
        walker.sort(RevSort.TOPO);
        walker.sort(RevSort.BOUNDARY, true);
        for (RevObject revObject : wantObj) {
            walker.markStart(revObject);
        }
        for (RevObject revObject : baseObj) {
            walker.markUninteresting(revObject);
        }
    }

    private static boolean includesAllTips(CachedPack pack, RevFlag include, ObjectWalk walker) {
        for (ObjectId id : pack.getTips()) {
            if (walker.lookupOrNull(id).has(include)) continue;
            return false;
        }
        return true;
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        this.addObject(object, 0);
    }

    private void addObject(RevObject object, int pathHashCode) {
        ObjectToPack otp = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(object) : new ObjectToPack(object);
        otp.setPathHash(pathHashCode);
        this.objectsLists[object.getType()].add(otp);
        this.objectsMap.add(otp);
    }

    public void select(ObjectToPack otp, StoredObjectRepresentation next) {
        int nFmt = next.getFormat();
        if (!this.cachedPacks.isEmpty()) {
            if (otp.isEdge()) {
                return;
            }
            if (nFmt == 1 | nFmt == 0) {
                for (CachedPack pack : this.cachedPacks) {
                    if (!pack.hasObject(otp, next)) continue;
                    otp.setEdge();
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.pruneCurrentObjectList = true;
                    return;
                }
            }
        }
        if (nFmt == 0 && this.reuseDeltas && this.reuseDeltaFor(otp)) {
            ObjectId baseId = next.getDeltaBase();
            ObjectToPack ptr = this.objectsMap.get(baseId);
            if (ptr != null && !ptr.isEdge()) {
                otp.setDeltaBase(ptr);
                otp.setReuseAsIs();
            } else if (this.thin && ptr != null && ptr.isEdge()) {
                otp.setDeltaBase(baseId);
                otp.setReuseAsIs();
            } else {
                otp.clearDeltaBase();
                otp.clearReuseAsIs();
            }
        } else if (nFmt == 1 && this.config.isReuseObjects()) {
            int nWeight = next.getWeight();
            if (otp.isReuseAsIs() && !otp.isDeltaRepresentation() && otp.getWeight() <= nWeight) {
                return;
            }
            otp.clearDeltaBase();
            otp.setReuseAsIs();
            otp.setWeight(nWeight);
        } else {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
        otp.select(next);
    }

    private boolean reuseDeltaFor(ObjectToPack otp) {
        switch (otp.getType()) {
            case 1: {
                return this.reuseDeltaCommits;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Statistics {
        Set<ObjectId> interestingObjects;
        Set<ObjectId> uninterestingObjects;
        Collection<CachedPack> reusedPacks;
        int deltaSearchNonEdgeObjects;
        int deltasFound;
        long totalObjects;
        long totalDeltas;
        long reusedObjects;
        long reusedDeltas;
        long totalBytes;
        long thinPackBytes;
        long timeCounting;
        long timeSearchingForReuse;
        long timeSearchingForSizes;
        long timeCompressing;
        long timeWriting;
        ObjectType[] objectTypes = new ObjectType[5];

        public Statistics() {
            this.objectTypes[1] = new ObjectType();
            this.objectTypes[2] = new ObjectType();
            this.objectTypes[3] = new ObjectType();
            this.objectTypes[4] = new ObjectType();
        }

        public Set<ObjectId> getInterestingObjects() {
            return this.interestingObjects;
        }

        public Set<ObjectId> getUninterestingObjects() {
            return this.uninterestingObjects;
        }

        public Collection<CachedPack> getReusedPacks() {
            return this.reusedPacks;
        }

        public int getDeltaSearchNonEdgeObjects() {
            return this.deltaSearchNonEdgeObjects;
        }

        public int getDeltasFound() {
            return this.deltasFound;
        }

        public long getTotalObjects() {
            return this.totalObjects;
        }

        public long getTotalDeltas() {
            return this.totalDeltas;
        }

        public long getReusedObjects() {
            return this.reusedObjects;
        }

        public long getReusedDeltas() {
            return this.reusedDeltas;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public long getThinPackBytes() {
            return this.thinPackBytes;
        }

        public ObjectType byObjectType(int typeCode) {
            return this.objectTypes[typeCode];
        }

        public long getTimeCounting() {
            return this.timeCounting;
        }

        public long getTimeSearchingForReuse() {
            return this.timeSearchingForReuse;
        }

        public long getTimeSearchingForSizes() {
            return this.timeSearchingForSizes;
        }

        public long getTimeCompressing() {
            return this.timeCompressing;
        }

        public long getTimeWriting() {
            return this.timeWriting;
        }

        public double getTransferRate() {
            return (double)this.getTotalBytes() / ((double)this.getTimeWriting() / 1000.0);
        }

        public String getMessage() {
            return MessageFormat.format(JGitText.get().packWriterStatistics, this.totalObjects, this.totalDeltas, this.reusedObjects, this.reusedDeltas);
        }

        public static class ObjectType {
            long cntObjects;
            long cntDeltas;
            long reusedObjects;
            long reusedDeltas;
            long bytes;
            long deltaBytes;

            public long getObjects() {
                return this.cntObjects;
            }

            public long getDeltas() {
                return this.cntDeltas;
            }

            public long getReusedObjects() {
                return this.reusedObjects;
            }

            public long getReusedDeltas() {
                return this.reusedDeltas;
            }

            public long getBytes() {
                return this.bytes;
            }

            public long getDeltaBytes() {
                return this.deltaBytes;
            }
        }
    }
}

