/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.inboundroutes;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.inboundroutes.Filter;
import com.mailersend.sdk.inboundroutes.Forward;
import com.mailersend.sdk.inboundroutes.MxValues;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class InboundRoute {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="address")
    public String address;
    @SerializedName(value="domain")
    public String domain;
    @SerializedName(value="dns_checked_at")
    private String dnsCheckedAtString;
    public Date dnsCheckedAt;
    @SerializedName(value="enabled")
    public boolean enabled;
    @SerializedName(value="filters")
    public Filter[] filters;
    @SerializedName(value="forwards")
    public Forward[] forwards;
    @SerializedName(value="mxValues")
    public MxValues mxValues;

    public void postDeserialize() {
        if (this.dnsCheckedAtString != null && !this.dnsCheckedAtString.isBlank()) {
            TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(this.dnsCheckedAtString);
            Instant instant = Instant.from(ta);
            this.dnsCheckedAt = Date.from(instant);
        }
    }
}

