/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.recipients;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.recipients.Recipient;
import com.mailersend.sdk.recipients.RecipientResponse;
import com.mailersend.sdk.recipients.Suppressions;
import com.mailersend.sdk.util.ApiRecipientsList;
import java.util.ArrayList;

public class Recipients {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String domainIdFilter = null;
    private Suppressions suppressions;

    public Recipients(MailerSend ref) {
        this.apiObjectReference = ref;
        this.suppressions = new Suppressions(ref);
    }

    public Suppressions suppressions() {
        return this.suppressions;
    }

    public Recipients page(int page) {
        this.pageFilter = page;
        return this;
    }

    public Recipients limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public Recipients domainId(String domainId) {
        this.domainIdFilter = domainId;
        return this;
    }

    public ApiRecipientsList getRecipients() throws MailerSendException {
        String endpoint = "/recipients".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        ApiRecipientsList response = api.getRequest(endpoint, ApiRecipientsList.class);
        return response;
    }

    public Recipient getRecipient(String recipientId) throws MailerSendException {
        String endpoint = "/recipients/".concat(recipientId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        RecipientResponse response = api.getRequest(endpoint, RecipientResponse.class);
        return response.recipient;
    }

    public MailerSendResponse deleteRecipient(String recipientId) throws MailerSendException {
        String endpoint = "/recipients/".concat(recipientId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return response;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.domainIdFilter != null) {
            params.add("domain_id=".concat(this.domainIdFilter));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

