/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.recipients;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.recipients.BlocklistAddBody;
import com.mailersend.sdk.recipients.BlocklistItem;
import com.mailersend.sdk.recipients.BlocklistListResponse;
import com.mailersend.sdk.recipients.SuppressionAddBody;
import com.mailersend.sdk.recipients.SuppressionList;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;

public class SuppressionAddBuilder {
    private MailerSend apiObjectReference;
    BlocklistAddBody blocklistRequestBody = new BlocklistAddBody();
    SuppressionAddBody suppressionAddBody = new SuppressionAddBody();

    protected SuppressionAddBuilder(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
    }

    public void recipient(String recipient) {
        this.blocklistRequestBody.recipients.add(recipient);
        this.suppressionAddBody.recipients.add(recipient);
    }

    public void pattern(String pattern) {
        this.blocklistRequestBody.patterns.add(pattern);
    }

    public void domainId(String domainId) {
        this.blocklistRequestBody.domainId = domainId;
        this.suppressionAddBody.domainId = domainId;
    }

    public BlocklistItem[] addToBlocklist() throws MailerSendException {
        if (this.blocklistRequestBody.patterns.size() == 0 && this.blocklistRequestBody.recipients.size() == 0) {
            throw new MailerSendException("No patterns or recipients specified for blocklist");
        }
        String endpoint = "/suppressions/blocklist";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.blocklistRequestBody);
        this.blocklistRequestBody.reset();
        this.suppressionAddBody.reset();
        BlocklistListResponse response = api.postRequest(endpoint, json, BlocklistListResponse.class);
        return response.items;
    }

    public SuppressionList addRecipientsToHardBounces() throws MailerSendException {
        return this.addRecipientsToSuppressionList("/suppressions/hard-bounces");
    }

    public SuppressionList addRecipientsToSpamComplaints() throws MailerSendException {
        return this.addRecipientsToSuppressionList("/suppressions/spam-complaints");
    }

    public SuppressionList addRecipientsToUnsubscribes() throws MailerSendException {
        return this.addRecipientsToSuppressionList("/suppressions/unsubscribes");
    }

    private SuppressionList addRecipientsToSuppressionList(String endpoint) throws MailerSendException {
        if (this.suppressionAddBody.recipients.size() == 0) {
            throw new MailerSendException("No recipients specified for suppression list");
        }
        if (this.suppressionAddBody.domainId == null) {
            throw new MailerSendException("No domain id specified");
        }
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.suppressionAddBody);
        this.blocklistRequestBody.reset();
        this.suppressionAddBody.reset();
        SuppressionList response = api.postRequest(endpoint, json, SuppressionList.class);
        return response;
    }
}

