/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms.recipients;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.sms.recipients.SingleSmsRecipientResponse;
import com.mailersend.sdk.sms.recipients.SmsRecipient;
import com.mailersend.sdk.sms.recipients.SmsRecipientList;
import java.util.ArrayList;

public class SmsRecipients {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String statusFilter;
    private String numberIdFilter;

    public SmsRecipients(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public SmsRecipients page(int page) {
        this.pageFilter = page;
        return this;
    }

    public SmsRecipients limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public SmsRecipients status(String status) {
        this.statusFilter = status;
        return this;
    }

    public SmsRecipients numberId(String numberId) {
        this.numberIdFilter = numberId;
        return this;
    }

    public SmsRecipientList getRecipients() throws MailerSendException {
        String endpoint = "/sms-recipients".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SmsRecipientList response = api.getRequest(endpoint, SmsRecipientList.class);
        response.postDeserialize();
        return response;
    }

    public SmsRecipient getRecipient(String recipientId) throws MailerSendException {
        String endpoint = "/sms-recipients/".concat(recipientId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleSmsRecipientResponse response = api.getRequest(endpoint, SingleSmsRecipientResponse.class);
        response.recipient.postDeserialize();
        return response.recipient;
    }

    public SmsRecipient updateRecipient(String recipientId, String status) throws MailerSendException {
        String endpoint = "/sms-recipients/".concat(recipientId).concat("?status=").concat(status);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleSmsRecipientResponse response = api.putRequest(endpoint, null, SingleSmsRecipientResponse.class);
        response.recipient.postDeserialize();
        return response.recipient;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.statusFilter != null) {
            params.add("status=".concat(this.statusFilter));
        }
        if (this.numberIdFilter != null) {
            params.add("sms_number_id=".concat(this.numberIdFilter));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

