/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.tokens;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.tokens.Token;
import com.mailersend.sdk.tokens.TokenAddBuilder;
import com.mailersend.sdk.tokens.TokenResponse;

public class Tokens {
    private MailerSend apiObjectReference;
    private TokenAddBuilder addTokenBuilder;

    public Tokens(MailerSend ref) {
        this.apiObjectReference = ref;
        this.addTokenBuilder = new TokenAddBuilder(ref);
    }

    public TokenAddBuilder addBuilder() {
        return this.addTokenBuilder;
    }

    public Token updateToken(String tokenId, boolean paused) throws MailerSendException {
        String endpoint = "/token/".concat(tokenId).concat("/settings");
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        String json = "{\"status\":\"pause\"}";
        if (!paused) {
            json = "{\"status\":\"unpause\"}";
        }
        TokenResponse response = api.putRequest(endpoint, json, TokenResponse.class);
        response.token.postDeserialize();
        return response.token;
    }

    public MailerSendResponse deleteToken(String tokenId) throws MailerSendException {
        String endpoint = "/token/".concat(tokenId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return response;
    }
}

