/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.webhooks;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.webhooks.Webhook;
import com.mailersend.sdk.webhooks.WebhookResponse;
import com.mailersend.sdk.webhooks.WebhooksBuilder;
import com.mailersend.sdk.webhooks.WebhooksList;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class Webhooks {
    private MailerSend apiObjectReference;
    private WebhooksBuilder webhooksBuilder;
    private int pageFilter = 1;
    private int limitFilter = 25;

    public Webhooks(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
        this.webhooksBuilder = new WebhooksBuilder(apiObjectRef);
    }

    public Webhooks page(int page) {
        this.pageFilter = page;
        return this;
    }

    public Webhooks limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public WebhooksBuilder builder() {
        return this.webhooksBuilder;
    }

    public WebhooksList getWebhooks(String domainId) throws MailerSendException {
        String endpoint = "/webhooks".concat(this.prepareParamsUrl(domainId));
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        WebhooksList response = api.getRequest(endpoint, WebhooksList.class);
        response.postDeserialize();
        return response;
    }

    public Webhook getWebhook(String webhookId) throws MailerSendException {
        String endpoint = "/webhooks/".concat(webhookId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        WebhookResponse response = api.getRequest(endpoint, WebhookResponse.class);
        response.webhook.postDeserialize();
        return response.webhook;
    }

    public boolean deleteWebhook(String webhookId) throws MailerSendException {
        String endpoint = "/webhooks/".concat(webhookId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return IntStream.of(200, 204, 202).anyMatch(x -> x == response.responseStatusCode);
    }

    private String prepareParamsUrl(String domainId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        params.add("domain_id=".concat(domainId));
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

