/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.webhooks;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import com.mailersend.sdk.webhooks.Webhook;
import com.mailersend.sdk.webhooks.WebhookEvents;
import com.mailersend.sdk.webhooks.WebhookResponse;
import com.mailersend.sdk.webhooks.WebhooksBuilderBody;
import java.util.Arrays;

public class WebhooksBuilder {
    private WebhooksBuilderBody builderBody = new WebhooksBuilderBody();
    private MailerSend apiObjectReference;

    protected WebhooksBuilder(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
    }

    public WebhooksBuilder url(String url) {
        this.builderBody.url = url;
        return this;
    }

    public WebhooksBuilder name(String name) {
        this.builderBody.name = name;
        return this;
    }

    public WebhooksBuilder addEvent(String event) {
        this.builderBody.events.add(event);
        return this;
    }

    public WebhooksBuilder clearEvents() {
        this.builderBody.events.clear();
        return this;
    }

    public Webhook createWebhook(String domainId) throws MailerSendException {
        this.builderBody.domainId = domainId;
        if (this.builderBody.name == null || this.builderBody.name.isBlank()) {
            throw new MailerSendException("Webhook name cannot be empty");
        }
        if (this.builderBody.url == null || this.builderBody.url.isBlank()) {
            throw new MailerSendException("Webhook URL cannot be empty");
        }
        if (domainId == null || domainId.isBlank()) {
            throw new MailerSendException("Domain ID cannot be empty");
        }
        for (String event : this.builderBody.events) {
            if (Arrays.asList(WebhookEvents.events).contains(event)) continue;
            throw new MailerSendException("Webhook event is not valid");
        }
        String endpoint = "/webhooks";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody.reset();
        WebhookResponse response = api.postRequest(endpoint, json, WebhookResponse.class);
        return response.webhook;
    }

    public Webhook updateWebhook(String webhookId) throws MailerSendException {
        if (webhookId == null || webhookId.isBlank()) {
            throw new MailerSendException("Domain ID cannot be empty");
        }
        String endpoint = "/webhooks/".concat(webhookId);
        if (this.builderBody.events.size() == 0) {
            this.builderBody.events = null;
        } else {
            for (String event : this.builderBody.events) {
                if (Arrays.asList(WebhookEvents.events).contains(event)) continue;
                throw new MailerSendException("Webhook event is not valid");
            }
        }
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody.reset();
        WebhookResponse response = api.putRequest(endpoint, json, WebhookResponse.class);
        return response.webhook;
    }
}

