/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.marcnuri.yakc.api.Api;
import com.marcnuri.yakc.config.Configuration;
import com.marcnuri.yakc.config.ConfigurationResolver;
import com.marcnuri.yakc.config.OkHttpClientConfigurator;
import com.marcnuri.yakc.retrofit.KubernetesCallAdapterFactory;
import com.marcnuri.yakc.serialization.GoCompatibleTimeModule;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class KubernetesClient
implements Closeable {
    private static final Logger log = Logger.getLogger(KubernetesClient.class.getName());
    private Configuration configuration;
    private final OkHttpClient okHttpClient;
    private final Retrofit retrofit;

    public KubernetesClient() {
        this(null);
    }

    public KubernetesClient(Configuration configuration) {
        this.configuration = KubernetesClient.initConfiguration(configuration);
        this.okHttpClient = OkHttpClientConfigurator.initOkHttpClient(this.configuration);
        this.retrofit = this.initRetrofit();
    }

    public <T extends Api> T create(Class<T> clazz) {
        return (T)((Api)this.retrofit.create(clazz));
    }

    private static Configuration initConfiguration(Configuration configuration) {
        Configuration ret;
        if (configuration == null) {
            try {
                ret = ConfigurationResolver.resolveConfig();
            }
            catch (IOException ex) {
                log.warning(String.format("Error while loading autodetected Configuration: %s", ex.getMessage()));
                ret = Configuration.builder().build();
            }
        } else {
            ret = configuration.toBuilder().build();
        }
        return ret;
    }

    private Retrofit initRetrofit() {
        ObjectMapper objectMapper = KubernetesClient.initObjectMapper();
        return new Retrofit.Builder().client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)KubernetesCallAdapterFactory.getInstance(this)).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).baseUrl(Objects.requireNonNull(this.configuration.getServer(), "Server URL configuration is a required")).build();
    }

    private static ObjectMapper initObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new GoCompatibleTimeModule());
        return objectMapper;
    }

    @Override
    public void close() {
        Optional.ofNullable(this.getOkHttpClient()).map(OkHttpClient::dispatcher).map(Dispatcher::executorService).ifPresent(ExecutorService::shutdownNow);
        Optional.ofNullable(this.getOkHttpClient()).map(OkHttpClient::connectionPool).ifPresent(ConnectionPool::evictAll);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }
}

