/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.config;

import com.marcnuri.yakc.config.ConfigurationSupplier;
import java.io.File;
import java.time.Duration;

public class Configuration {
    private String server;
    private String namespace;
    private boolean insecureSkipTlsVerify;
    private String certificateAuthorityData;
    private File certificateAuthority;
    private String clientCertificateData;
    private File clientCertificate;
    private String clientKeyData;
    private File clientKey;
    private ConfigurationSupplier<String> token;
    private ConfigurationSupplier<String> username;
    private ConfigurationSupplier<String> password;
    private Duration connectTimeout;
    private Duration readTimeout;

    Configuration(String server, String namespace, boolean insecureSkipTlsVerify, String certificateAuthorityData, File certificateAuthority, String clientCertificateData, File clientCertificate, String clientKeyData, File clientKey, ConfigurationSupplier<String> token, ConfigurationSupplier<String> username, ConfigurationSupplier<String> password, Duration connectTimeout, Duration readTimeout) {
        this.server = server;
        this.namespace = namespace;
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        this.certificateAuthorityData = certificateAuthorityData;
        this.certificateAuthority = certificateAuthority;
        this.clientCertificateData = clientCertificateData;
        this.clientCertificate = clientCertificate;
        this.clientKeyData = clientKeyData;
        this.clientKey = clientKey;
        this.token = token;
        this.username = username;
        this.password = password;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public ConfigurationBuilder toBuilder() {
        return new ConfigurationBuilder().server(this.server).namespace(this.namespace).insecureSkipTlsVerify(this.insecureSkipTlsVerify).certificateAuthorityData(this.certificateAuthorityData).certificateAuthority(this.certificateAuthority).clientCertificateData(this.clientCertificateData).clientCertificate(this.clientCertificate).clientKeyData(this.clientKeyData).clientKey(this.clientKey).token(this.token).username(this.username).password(this.password).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout);
    }

    public String getServer() {
        return this.server;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    public File getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public String getClientCertificateData() {
        return this.clientCertificateData;
    }

    public File getClientCertificate() {
        return this.clientCertificate;
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public File getClientKey() {
        return this.clientKey;
    }

    public ConfigurationSupplier<String> getToken() {
        return this.token;
    }

    public ConfigurationSupplier<String> getUsername() {
        return this.username;
    }

    public ConfigurationSupplier<String> getPassword() {
        return this.password;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setInsecureSkipTlsVerify(boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
    }

    public void setCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
    }

    public void setCertificateAuthority(File certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
    }

    public void setClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
    }

    public void setClientCertificate(File clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public void setClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
    }

    public void setClientKey(File clientKey) {
        this.clientKey = clientKey;
    }

    public void setToken(ConfigurationSupplier<String> token) {
        this.token = token;
    }

    public void setUsername(ConfigurationSupplier<String> username) {
        this.username = username;
    }

    public void setPassword(ConfigurationSupplier<String> password) {
        this.password = password;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (this.isInsecureSkipTlsVerify() != other.isInsecureSkipTlsVerify()) {
            return false;
        }
        String this$certificateAuthorityData = this.getCertificateAuthorityData();
        String other$certificateAuthorityData = other.getCertificateAuthorityData();
        if (this$certificateAuthorityData == null ? other$certificateAuthorityData != null : !this$certificateAuthorityData.equals(other$certificateAuthorityData)) {
            return false;
        }
        File this$certificateAuthority = this.getCertificateAuthority();
        File other$certificateAuthority = other.getCertificateAuthority();
        if (this$certificateAuthority == null ? other$certificateAuthority != null : !((Object)this$certificateAuthority).equals(other$certificateAuthority)) {
            return false;
        }
        String this$clientCertificateData = this.getClientCertificateData();
        String other$clientCertificateData = other.getClientCertificateData();
        if (this$clientCertificateData == null ? other$clientCertificateData != null : !this$clientCertificateData.equals(other$clientCertificateData)) {
            return false;
        }
        File this$clientCertificate = this.getClientCertificate();
        File other$clientCertificate = other.getClientCertificate();
        if (this$clientCertificate == null ? other$clientCertificate != null : !((Object)this$clientCertificate).equals(other$clientCertificate)) {
            return false;
        }
        String this$clientKeyData = this.getClientKeyData();
        String other$clientKeyData = other.getClientKeyData();
        if (this$clientKeyData == null ? other$clientKeyData != null : !this$clientKeyData.equals(other$clientKeyData)) {
            return false;
        }
        File this$clientKey = this.getClientKey();
        File other$clientKey = other.getClientKey();
        if (this$clientKey == null ? other$clientKey != null : !((Object)this$clientKey).equals(other$clientKey)) {
            return false;
        }
        ConfigurationSupplier<String> this$token = this.getToken();
        ConfigurationSupplier<String> other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        ConfigurationSupplier<String> this$username = this.getUsername();
        ConfigurationSupplier<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        ConfigurationSupplier<String> this$password = this.getPassword();
        ConfigurationSupplier<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        result = result * 59 + (this.isInsecureSkipTlsVerify() ? 79 : 97);
        String $certificateAuthorityData = this.getCertificateAuthorityData();
        result = result * 59 + ($certificateAuthorityData == null ? 43 : $certificateAuthorityData.hashCode());
        File $certificateAuthority = this.getCertificateAuthority();
        result = result * 59 + ($certificateAuthority == null ? 43 : ((Object)$certificateAuthority).hashCode());
        String $clientCertificateData = this.getClientCertificateData();
        result = result * 59 + ($clientCertificateData == null ? 43 : $clientCertificateData.hashCode());
        File $clientCertificate = this.getClientCertificate();
        result = result * 59 + ($clientCertificate == null ? 43 : ((Object)$clientCertificate).hashCode());
        String $clientKeyData = this.getClientKeyData();
        result = result * 59 + ($clientKeyData == null ? 43 : $clientKeyData.hashCode());
        File $clientKey = this.getClientKey();
        result = result * 59 + ($clientKey == null ? 43 : ((Object)$clientKey).hashCode());
        ConfigurationSupplier<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        ConfigurationSupplier<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        ConfigurationSupplier<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(server=" + this.getServer() + ", namespace=" + this.getNamespace() + ", insecureSkipTlsVerify=" + this.isInsecureSkipTlsVerify() + ", certificateAuthorityData=" + this.getCertificateAuthorityData() + ", certificateAuthority=" + this.getCertificateAuthority() + ", clientCertificateData=" + this.getClientCertificateData() + ", clientCertificate=" + this.getClientCertificate() + ", clientKeyData=" + this.getClientKeyData() + ", clientKey=" + this.getClientKey() + ", token=" + this.getToken() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }

    public static class ConfigurationBuilder {
        private String server;
        private String namespace;
        private boolean insecureSkipTlsVerify;
        private String certificateAuthorityData;
        private File certificateAuthority;
        private String clientCertificateData;
        private File clientCertificate;
        private String clientKeyData;
        private File clientKey;
        private ConfigurationSupplier<String> token;
        private ConfigurationSupplier<String> username;
        private ConfigurationSupplier<String> password;
        private Duration connectTimeout;
        private Duration readTimeout;

        ConfigurationBuilder() {
        }

        public ConfigurationBuilder server(String server) {
            this.server = server;
            return this;
        }

        public ConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ConfigurationBuilder insecureSkipTlsVerify(boolean insecureSkipTlsVerify) {
            this.insecureSkipTlsVerify = insecureSkipTlsVerify;
            return this;
        }

        public ConfigurationBuilder certificateAuthorityData(String certificateAuthorityData) {
            this.certificateAuthorityData = certificateAuthorityData;
            return this;
        }

        public ConfigurationBuilder certificateAuthority(File certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public ConfigurationBuilder clientCertificateData(String clientCertificateData) {
            this.clientCertificateData = clientCertificateData;
            return this;
        }

        public ConfigurationBuilder clientCertificate(File clientCertificate) {
            this.clientCertificate = clientCertificate;
            return this;
        }

        public ConfigurationBuilder clientKeyData(String clientKeyData) {
            this.clientKeyData = clientKeyData;
            return this;
        }

        public ConfigurationBuilder clientKey(File clientKey) {
            this.clientKey = clientKey;
            return this;
        }

        public ConfigurationBuilder token(ConfigurationSupplier<String> token) {
            this.token = token;
            return this;
        }

        public ConfigurationBuilder username(ConfigurationSupplier<String> username) {
            this.username = username;
            return this;
        }

        public ConfigurationBuilder password(ConfigurationSupplier<String> password) {
            this.password = password;
            return this;
        }

        public ConfigurationBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ConfigurationBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.server, this.namespace, this.insecureSkipTlsVerify, this.certificateAuthorityData, this.certificateAuthority, this.clientCertificateData, this.clientCertificate, this.clientKeyData, this.clientKey, this.token, this.username, this.password, this.connectTimeout, this.readTimeout);
        }

        public String toString() {
            return "Configuration.ConfigurationBuilder(server=" + this.server + ", namespace=" + this.namespace + ", insecureSkipTlsVerify=" + this.insecureSkipTlsVerify + ", certificateAuthorityData=" + this.certificateAuthorityData + ", certificateAuthority=" + this.certificateAuthority + ", clientCertificateData=" + this.clientCertificateData + ", clientCertificate=" + this.clientCertificate + ", clientKeyData=" + this.clientKeyData + ", clientKey=" + this.clientKey + ", token=" + this.token + ", username=" + this.username + ", password=" + this.password + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ")";
        }
    }
}

