/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.config;

import com.marcnuri.yakc.config.Configuration;
import com.marcnuri.yakc.config.KubeConfig;
import com.marcnuri.yakc.config.KubeConfigResolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;

public class ConfigurationResolver {
    private static final String SA_TOKEN_POD_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String NAMESPACE_POD_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private static final String CA_POD_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";

    public static Configuration resolveConfig() throws IOException {
        if (new File(SA_TOKEN_POD_FILE).exists()) {
            return ConfigurationResolver.resolvePodConfig();
        }
        return ConfigurationResolver.resolveKubeConfig();
    }

    public static Configuration resolvePodConfig() throws IOException {
        Configuration.ConfigurationBuilder cb = Configuration.builder();
        cb.server("https://kubernetes.default.svc");
        cb.certificateAuthority(new File(CA_POD_FILE));
        cb.token(() -> ConfigurationResolver.readFile(new File(SA_TOKEN_POD_FILE)));
        cb.namespace(ConfigurationResolver.readFile(new File(NAMESPACE_POD_FILE)));
        return cb.build();
    }

    public static Configuration resolveKubeConfig() throws IOException {
        KubeConfigResolver kcResolver = new KubeConfigResolver();
        if (kcResolver.getKubeConfig().isPresent()) {
            Optional<KubeConfig.Context> context = kcResolver.getCurrentContext().map(KubeConfig.NamedContext::getContext);
            Optional<KubeConfig.Cluster> cluster = kcResolver.getCurrentCluster().map(KubeConfig.NamedCluster::getCluster);
            Optional<KubeConfig.AuthInfo> authInfo = kcResolver.getCurrentAuthInfo();
            return Configuration.builder().server(cluster.map(KubeConfig.Cluster::getServer).orElse(null)).namespace(context.map(KubeConfig.Context::getNamespace).orElse(null)).insecureSkipTlsVerify(cluster.map(KubeConfig.Cluster::getInsecureSkipTlsVerify).orElse(false)).certificateAuthorityData(cluster.map(KubeConfig.Cluster::getCertificateAuthorityData).orElse(null)).certificateAuthority(cluster.map(KubeConfig.Cluster::getCertificateAuthority).map(File::new).filter(File::exists).orElse(null)).clientCertificateData(authInfo.map(KubeConfig.AuthInfo::getClientCertificateData).orElse(null)).clientCertificate(authInfo.map(KubeConfig.AuthInfo::getClientCertificate).map(File::new).filter(File::exists).orElse(null)).clientKeyData(authInfo.map(KubeConfig.AuthInfo::getClientKeyData).orElse(null)).clientKey(authInfo.map(KubeConfig.AuthInfo::getClientKey).map(File::new).filter(File::exists).orElse(null)).username(() -> kcResolver.getCurrentAuthInfo().map(KubeConfig.AuthInfo::getUsername).orElse(null)).password(() -> kcResolver.getCurrentAuthInfo().map(KubeConfig.AuthInfo::getUsername).orElse(null)).token(() -> kcResolver.getCurrentAuthInfo().map(KubeConfig.AuthInfo::getToken).orElse(null)).build();
        }
        return Configuration.builder().build();
    }

    private static String readFile(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8).trim().replace("\n", "").replace("\r", "");
        }
        return null;
    }

    private ConfigurationResolver() {
    }
}

