/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.marcnuri.yakc.config.KubeConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class KubeConfigResolver {
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final Supplier<File> kubeConfigFileResolver;
    private final AtomicLong lastModified;
    private final AtomicReference<KubeConfig> currentConfig;
    private final AtomicReference<KubeConfig.NamedContext> selectedContext;

    KubeConfigResolver() {
        this(() -> new File(System.getProperty("user.home")).toPath().resolve(".kube").resolve("config").toFile());
    }

    KubeConfigResolver(Supplier<File> kubeConfigFileResolver) {
        this.kubeConfigFileResolver = kubeConfigFileResolver;
        this.lastModified = new AtomicLong(0L);
        this.currentConfig = new AtomicReference<Object>(null);
        this.selectedContext = new AtomicReference<Object>(null);
    }

    Optional<KubeConfig> getKubeConfig() throws IOException {
        File kubeConfigFile = this.kubeConfigFileResolver.get();
        if (!kubeConfigFile.exists()) {
            return Optional.empty();
        }
        if (kubeConfigFile.lastModified() != this.lastModified.get() || this.currentConfig.get() == null) {
            this.lastModified.set(kubeConfigFile.lastModified());
            this.currentConfig.set((KubeConfig)MAPPER.readValue(kubeConfigFile, KubeConfig.class));
        }
        return Optional.of(this.currentConfig.get());
    }

    Optional<KubeConfig.NamedContext> getCurrentContext() throws IOException {
        if (this.selectedContext.get() != null) {
            return Optional.of(this.selectedContext.get());
        }
        KubeConfig kubeConfig = this.getKubeConfig().orElse(null);
        if (kubeConfig != null) {
            return kubeConfig.getContexts().stream().filter(c -> c.getName().equals(kubeConfig.getCurrentContext())).findFirst().map(nc -> {
                this.selectedContext.set((KubeConfig.NamedContext)nc);
                return nc;
            });
        }
        return Optional.empty();
    }

    Optional<KubeConfig.NamedCluster> getCurrentCluster() throws IOException {
        KubeConfig kubeConfig = this.getKubeConfig().orElse(null);
        String currentCluster = this.getCurrentContext().map(KubeConfig.NamedContext::getContext).map(KubeConfig.Context::getCluster).orElse(null);
        if (kubeConfig != null && currentCluster != null) {
            return Optional.ofNullable(kubeConfig.getClusters()).orElse(Collections.emptyList()).stream().filter(c -> c.getName().equals(currentCluster)).findFirst();
        }
        return Optional.empty();
    }

    Optional<KubeConfig.NamedAuthInfo> getCurrentNamedAuthInfo() throws IOException {
        KubeConfig kubeConfig = this.getKubeConfig().orElse(null);
        String currentUser = this.getCurrentContext().map(KubeConfig.NamedContext::getContext).map(KubeConfig.Context::getUser).orElse(null);
        if (kubeConfig != null && currentUser != null) {
            return Optional.ofNullable(kubeConfig.getUsers()).orElse(Collections.emptyList()).stream().filter(c -> c.getName().equals(currentUser)).findFirst();
        }
        return Optional.empty();
    }

    Optional<KubeConfig.AuthInfo> getCurrentAuthInfo() throws IOException {
        return this.getCurrentNamedAuthInfo().map(KubeConfig.NamedAuthInfo::getUser);
    }
}

