/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.config;

import com.marcnuri.yakc.config.Configuration;
import com.marcnuri.yakc.config.ConfigurationSupplier;
import com.marcnuri.yakc.config.Defaults;
import com.marcnuri.yakc.ssl.SSLResolver;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;

public class OkHttpClientConfigurator {
    private static final Logger log = Logger.getLogger(OkHttpClientConfigurator.class.getName());
    private static final String HEADER_AUTHORIZATION = "Authorization";

    public static OkHttpClient initOkHttpClient(Configuration optionalConfiguration) {
        Configuration configuration = Optional.ofNullable(optionalConfiguration).orElse(Configuration.builder().build());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(Defaults.getConnectTimeout(configuration)).readTimeout(Defaults.getReadTimeout(configuration)).followRedirects(true).followSslRedirects(true);
        if (SSLResolver.isTrustAllCertificates(configuration)) {
            builder.hostnameVerifier((hostname, session) -> true);
        }
        try {
            TrustManager[] trustManagers = SSLResolver.trustManagers(configuration);
            KeyManager[] keyManagers = SSLResolver.hasClientCertificate(configuration) ? SSLResolver.keyManagers(configuration) : null;
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Error while loading certificates: %s", e.getMessage()), e);
        }
        builder.addInterceptor(c -> {
            String currentUserName = Optional.ofNullable(configuration.getUsername()).map(OkHttpClientConfigurator::getConfiguration).orElse(null);
            String currentPassword = Optional.ofNullable(configuration.getPassword()).map(OkHttpClientConfigurator::getConfiguration).orElse(null);
            if (currentUserName != null) {
                c.proceed(c.request().newBuilder().addHeader(HEADER_AUTHORIZATION, Credentials.basic((String)currentUserName, (String)currentPassword)).build());
            }
            return c.proceed(c.request());
        });
        builder.addInterceptor(c -> {
            String currentToken = Optional.ofNullable(configuration.getToken()).map(OkHttpClientConfigurator::getConfiguration).orElse(null);
            if (currentToken != null) {
                return c.proceed(c.request().newBuilder().header(HEADER_AUTHORIZATION, String.format("Bearer %s", currentToken)).build());
            }
            return c.proceed(c.request());
        });
        return builder.build();
    }

    private static <T> T getConfiguration(ConfigurationSupplier<T> cs) {
        try {
            return cs.get();
        }
        catch (IOException e) {
            return null;
        }
    }

    private OkHttpClientConfigurator() {
    }
}

