/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.retrofit;

import com.marcnuri.yakc.KubernetesClient;
import com.marcnuri.yakc.api.KubernetesCall;
import com.marcnuri.yakc.retrofit.KubernetesHttpCall;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;

public class KubernetesCallAdapter<T>
implements CallAdapter<T, KubernetesCall<T>> {
    private final Type responseType;
    private final KubernetesClient kubernetesClient;

    KubernetesCallAdapter(Type responseType, KubernetesClient kubernetesClient) {
        this.responseType = responseType;
        this.kubernetesClient = kubernetesClient;
    }

    public Type responseType() {
        return this.responseType;
    }

    public KubernetesCall<T> adapt(Call<T> call) {
        return new KubernetesHttpCall(this.responseType, call, this.kubernetesClient);
    }
}

