/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.retrofit;

import com.marcnuri.yakc.KubernetesClient;
import com.marcnuri.yakc.api.ExecMessage;
import com.marcnuri.yakc.api.KubernetesException;
import com.marcnuri.yakc.api.KubernetesExecCall;
import com.marcnuri.yakc.api.KubernetesListCall;
import com.marcnuri.yakc.api.WatchEvent;
import com.marcnuri.yakc.model.ListModel;
import com.marcnuri.yakc.reactivex.ExecOnSubscribe;
import com.marcnuri.yakc.reactivex.WatchOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Stream;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.Timeout;
import retrofit2.Call;
import retrofit2.Callback;

public class KubernetesHttpCall<T, W>
implements KubernetesListCall<T, W>,
KubernetesExecCall<T> {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private final Type responseType;
    private final Call<T> delegate;
    private final KubernetesClient kubernetesClient;

    KubernetesHttpCall(Type responseType, Call<T> delegate, KubernetesClient kubernetesClient) {
        this.responseType = responseType;
        this.delegate = delegate;
        this.kubernetesClient = kubernetesClient;
    }

    public T get() throws IOException {
        return (T)this.get((Class)this.responseType);
    }

    public <O> O get(Class<O> returnType) throws IOException {
        Response response = this.executeRaw();
        if (response.isSuccessful()) {
            String contentType = Optional.ofNullable(response.header(HEADER_CONTENT_TYPE)).orElseThrow(() -> KubernetesException.forResponse((String)"Response with no Content-Type", (Response)response));
            if (contentType.startsWith("text/") && returnType == String.class) {
                return returnType.cast(response.body() != null ? response.body().string() : "");
            }
            if (contentType.equalsIgnoreCase("application/json")) {
                return (O)this.kubernetesClient.getRetrofit().responseBodyConverter(returnType, new Annotation[0]).convert((Object)response.body());
            }
            throw KubernetesException.forResponse((String)"Unprocessable response body", (Response)response);
        }
        throw KubernetesException.forResponse((String)(response.body() == null ? "" : response.body().string()), (Response)response);
    }

    public Observable<WatchEvent<W>> watch() throws KubernetesException {
        return Observable.create(new WatchOnSubscribe(this.responseType, this.request(), this.kubernetesClient));
    }

    public Stream<W> stream() throws IOException {
        return ((ListModel)this.get()).getItems().stream();
    }

    public Observable<ExecMessage> exec() {
        return Observable.create((ObservableOnSubscribe)new ExecOnSubscribe(this.request(), this.kubernetesClient));
    }

    public WebSocket exec(WebSocketListener webSocketListener) {
        return this.kubernetesClient.getOkHttpClient().newWebSocket(this.request(), webSocketListener);
    }

    public Response executeRaw() throws IOException {
        return this.kubernetesClient.getRetrofit().callFactory().newCall(this.request()).execute();
    }

    public retrofit2.Response<T> execute() throws IOException {
        return this.delegate.execute();
    }

    public void enqueue(Callback<T> callback) {
        this.delegate.enqueue(callback);
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public KubernetesHttpCall<T, W> clone() {
        return new KubernetesHttpCall<T, W>(this.responseType, this.delegate.clone(), this.kubernetesClient);
    }

    public Request request() {
        return this.delegate.request();
    }

    public Timeout timeout() {
        return this.delegate.timeout();
    }
}

