/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.ssl;

import com.marcnuri.yakc.config.Configuration;
import com.marcnuri.yakc.ssl.AlwaysTrustManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import okio.ByteString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class SSLResolver {
    private static final Logger log = Logger.getLogger(SSLResolver.class.getName());
    public static final String TLS_V_1_2 = "TLSv1.2";
    private static final String JKS_TYPE = "JKS";
    private static final String X509_TYPE = "X509";
    private static final String DEFAULT_JAVA_TRUSTSTORE_P455W0RD = "changeit";

    public static boolean isTrustAllCertificates(Configuration configuration) {
        return configuration.isInsecureSkipTlsVerify();
    }

    public static boolean hasCertificateAuthority(Configuration configuration) {
        return configuration.getCertificateAuthority() != null || SSLResolver.isNotNullOrEmpty(configuration.getCertificateAuthorityData());
    }

    public static boolean hasClientCertificate(Configuration configuration) {
        boolean hasCert = configuration.getClientCertificate() != null || SSLResolver.isNotNullOrEmpty(configuration.getClientCertificateData());
        boolean hasKey = configuration.getClientKey() != null || SSLResolver.isNotNullOrEmpty(configuration.getClientKeyData());
        return hasCert && hasKey;
    }

    public static TrustManager[] trustManagers(Configuration configuration) throws IOException, GeneralSecurityException {
        if (SSLResolver.isTrustAllCertificates(configuration)) {
            return new TrustManager[]{new AlwaysTrustManager()};
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(SSLResolver.initTrustStore(configuration));
        return tmf.getTrustManagers();
    }

    public static KeyManager[] keyManagers(Configuration configuration) throws IOException, GeneralSecurityException {
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_TYPE);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        try (InputStream certIS = SSLResolver.certInputStream(configuration.getClientCertificateData(), configuration.getClientCertificate());
             InputStreamReader keyISR = new InputStreamReader(SSLResolver.certInputStream(configuration.getClientKeyData(), configuration.getClientKey()));
             InputStream javaIS = SSLResolver.loadJavaTrustStore();){
            Security.addProvider((Provider)new BouncyCastleProvider());
            Collection<? extends Certificate> certs = certFactory.generateCertificates(certIS);
            KeyStore keyStore = KeyStore.getInstance(JKS_TYPE);
            if (javaIS != null) {
                keyStore.load(javaIS, DEFAULT_JAVA_TRUSTSTORE_P455W0RD.toCharArray());
            } else {
                keyStore.load(null);
            }
            String alias = certs.stream().map(X509Certificate.class::cast).map(X509Certificate::getIssuerX500Principal).map(X500Principal::getName).collect(Collectors.joining("_"));
            keyStore.setKeyEntry(alias, SSLResolver.decodePrivateKey(keyISR), DEFAULT_JAVA_TRUSTSTORE_P455W0RD.toCharArray(), certs.toArray(new Certificate[0]));
            kmf.init(keyStore, DEFAULT_JAVA_TRUSTSTORE_P455W0RD.toCharArray());
        }
        return kmf.getKeyManagers();
    }

    private static KeyStore initTrustStore(Configuration configuration) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(JKS_TYPE);
        try (InputStream caIS = SSLResolver.certInputStream(configuration.getCertificateAuthorityData(), configuration.getCertificateAuthority());
             InputStream javaTrustStoreIS = SSLResolver.loadJavaTrustStore();){
            if (javaTrustStoreIS != null) {
                trustStore.load(javaTrustStoreIS, DEFAULT_JAVA_TRUSTSTORE_P455W0RD.toCharArray());
            } else {
                trustStore.load(null);
            }
            if (SSLResolver.hasCertificateAuthority(configuration)) {
                CertificateFactory certFactory = CertificateFactory.getInstance(X509_TYPE);
                X509Certificate caCert = (X509Certificate)certFactory.generateCertificate(caIS);
                trustStore.setCertificateEntry(caCert.getSubjectX500Principal().getName(), caCert);
            }
        }
        return trustStore;
    }

    private static InputStream loadJavaTrustStore() throws IOException {
        File javaTrustStore = Optional.ofNullable(System.getProperty("java.home")).map(File::new).map(f -> f.toPath().resolve("lib").resolve("security").resolve("cacerts").toFile()).filter(File::exists).filter(f -> f.length() > 0L).orElse(null);
        if (javaTrustStore != null) {
            return new FileInputStream(javaTrustStore);
        }
        log.warning("Java System trust store was not found");
        return null;
    }

    private static PrivateKey decodePrivateKey(InputStreamReader keyISR) throws IOException {
        PrivateKey privateKey;
        Object readKey = new PEMParser((Reader)keyISR).readObject();
        JcaPEMKeyConverter jcaConverter = new JcaPEMKeyConverter();
        if (readKey instanceof PEMKeyPair) {
            privateKey = jcaConverter.getPrivateKey(((PEMKeyPair)readKey).getPrivateKeyInfo());
        } else if (readKey instanceof PrivateKeyInfo) {
            privateKey = jcaConverter.getPrivateKey((PrivateKeyInfo)readKey);
        } else {
            throw new IOException("Invalid private key");
        }
        return privateKey;
    }

    private static InputStream certInputStream(String certData, File certFile) throws IOException {
        return Optional.ofNullable(SSLResolver.certInputStream(certData)).orElse(SSLResolver.certInputStream(certFile));
    }

    private static InputStream certInputStream(String certData) {
        if (!SSLResolver.isNotNullOrEmpty(certData)) {
            return null;
        }
        return new ByteArrayInputStream(Objects.requireNonNull(ByteString.decodeBase64((String)certData)).toByteArray());
    }

    private static boolean isNotNullOrEmpty(String string) {
        return Optional.ofNullable(string).filter(((Predicate<String>)String::isEmpty).negate()).isPresent();
    }

    private static InputStream certInputStream(File certFile) throws IOException {
        return certFile == null ? null : new FileInputStream(certFile);
    }

    private SSLResolver() {
    }
}

