/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.marvinformatics.formatter.ConfigurationSource;
import com.marvinformatics.formatter.Formatter;
import com.marvinformatics.formatter.LineEnding;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractFormatterTest {
    private static final String OUTPUT_DIR = "target/formatter-files/";
    private Formatter formatter;

    @Before
    public void setup() {
        HashMap<String, String> options = new HashMap<String, String>();
        this.tuneDefaultConfigs(options);
        final File targetDir = new File("target/testoutput");
        targetDir.mkdirs();
        this.formatter = this.createFormatter(options, new ConfigurationSource(){

            @Override
            public File getTargetDirectory() {
                return targetDir;
            }

            @Override
            public Charset getEncoding() {
                return Charsets.UTF_8;
            }

            @Override
            public String getCompilerSources() {
                return "9";
            }

            @Override
            public String getCompilerCompliance() {
                return "9";
            }

            @Override
            public String getCompilerCodegenTargetPlatform() {
                return "9";
            }

            @Override
            public LineEnding lineEnding() {
                return LineEnding.LF;
            }

            @Override
            public boolean isDryRun() {
                return false;
            }

            @Override
            public void info(String message) {
                System.out.println("INFO " + message);
            }

            @Override
            public void error(String message) {
                System.out.println("ERROR " + message);
            }

            @Override
            public void debug(String message) {
                System.out.println("DEBUG " + message);
            }

            @Override
            public void warn(String message, File sourceFile, Exception e) {
                System.out.println("WARN " + message);
                throw new RuntimeException(e);
            }
        });
    }

    public void tuneDefaultConfigs(Map<String, String> options) {
    }

    public abstract Formatter createFormatter(Map<String, String> var1, ConfigurationSource var2);

    @Test
    public void doTestFormat() throws IOException, NoSuchAlgorithmException {
        new File(OUTPUT_DIR, this.fileUnderTest()).mkdirs();
        File originalFile = new File(OUTPUT_DIR, String.valueOf(this.fileUnderTest()) + "/original");
        Files.copy((File)new File("src/test/resources/sample/", this.fileUnderTest()), (File)originalFile);
        File unformattedFile = this.createUnformatedFile(originalFile);
        String unformattedContent = Files.toString((File)unformattedFile, (Charset)Charsets.UTF_8);
        String originalContent = Files.toString((File)originalFile, (Charset)Charsets.UTF_8);
        String formattedContent = this.formatter.format(unformattedContent);
        File formattedFile = new File(OUTPUT_DIR, String.valueOf(this.fileUnderTest()) + "/formatted");
        Files.write((CharSequence)formattedContent, (File)formattedFile, (Charset)Charsets.UTF_8);
        String msg = "Files: \n-" + originalFile.getAbsolutePath() + "\n-" + formattedFile.getAbsolutePath();
        Assert.assertEquals((String)msg, (Object)originalContent, (Object)formattedContent);
        String expectedSha1 = Files.hash((File)originalFile, (HashFunction)Hashing.sha1()).toString();
        String sha1 = Files.hash((File)formattedFile, (HashFunction)Hashing.sha1()).toString();
        Assert.assertEquals((String)msg, (Object)expectedSha1, (Object)sha1);
    }

    public abstract String fileUnderTest();

    private File createUnformatedFile(File originalSourceFile) throws IOException {
        File unformatedFile = new File(OUTPUT_DIR, String.valueOf(this.fileUnderTest()) + "/unformatted");
        List content = Files.readLines((File)originalSourceFile, (Charset)Charsets.UTF_8);
        StringBuilder messedContent = new StringBuilder();
        for (String line : content) {
            if (line.contains("*")) {
                messedContent.append(line).append("\n");
                continue;
            }
            messedContent.append((CharSequence)this.randomSeparator()).append(line.trim()).append((CharSequence)this.randomSeparator());
        }
        Files.write((CharSequence)messedContent, (File)unformatedFile, (Charset)Charsets.UTF_8);
        return unformatedFile;
    }

    private StringBuilder randomSeparator() {
        Random random = new Random();
        int spaces = random.nextInt(10);
        StringBuilder separator = new StringBuilder();
        int i = 0;
        while (i < spaces) {
            if (i % 3 == 0) {
                separator.append('\t');
            } else {
                separator.append(' ');
            }
            ++i;
        }
        return separator;
    }
}

