/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;

public abstract class EncryptionConfig {
    Scheme scheme = Scheme.LEGACY;
    String encryptionKeyFingerprint;
    Certificate encryptionCertificate;
    PrivateKey decryptionKey;
    Map<String, String> encryptionPaths = Collections.emptyMap();
    Map<String, String> decryptionPaths = Collections.emptyMap();
    String encryptedValueFieldName = null;

    protected EncryptionConfig() {
    }

    public String getEncryptionKeyFingerprint() {
        return this.encryptionKeyFingerprint;
    }

    public Certificate getEncryptionCertificate() {
        return this.encryptionCertificate;
    }

    public PrivateKey getDecryptionKey() {
        return this.decryptionKey;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    Map<String, String> getEncryptionPaths() {
        return this.encryptionPaths;
    }

    Map<String, String> getDecryptionPaths() {
        return this.decryptionPaths;
    }

    String getEncryptedValueFieldName() {
        return this.encryptedValueFieldName;
    }

    public static enum Scheme {
        LEGACY,
        JWE;

    }
}

