/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

abstract class ArrayHeaderValueType<T, R>
extends AbstractHeader<T> {
    private final Class<R> componentType;

    public ArrayHeaderValueType(Class<T> type, CharSequence name, Class<R> componentType) {
        super(type, name);
        this.componentType = componentType;
        if (!type.isArray()) {
            throw new IllegalArgumentException(type.getName() + " is not an array type");
        }
        if (componentType != type.getComponentType()) {
            throw new IllegalArgumentException(componentType.getName() + " is not the array component type of " + type.getName());
        }
    }

    public Class<R> componentType() {
        return this.componentType;
    }

    public CharSequence toStringSingle(R single) {
        Object[] rs = (Object[])Array.newInstance(this.componentType, 1);
        rs[0] = single;
        return this.toCharSequence(rs);
    }

    public CharSequence toString(Collection<R> all) {
        if (all.size() == 1) {
            return this.toStringSingle(all.iterator().next());
        }
        Object[] rs = (Object[])Array.newInstance(this.componentType, all.size());
        Iterator<R> iter = all.iterator();
        for (int i = 0; i < rs.length; ++i) {
            rs[i] = iter.next();
        }
        return this.toCharSequence(rs);
    }
}

