/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.util.strings.Strings;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.util.AsciiString;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BoundedRange {
    private long start;
    private long end;
    private long of;
    private boolean valid;
    private final Pattern RANGE_PATTERN = Pattern.compile("bytes (\\d+)-(\\d+)\\/([\\d\\*]+)");
    private final Pattern INVALID_RANGE_PATTERN = Pattern.compile("bytes \\*\\/(\\d+)");

    public BoundedRange(long start, long end) {
        this(start, end, -1L);
    }

    public BoundedRange(long start, long end, long of) {
        if (end < start) {
            throw new IllegalArgumentException("End less than start: " + start + " end: " + end);
        }
        if ((of < start || of < end) && of != -1L) {
            throw new IllegalArgumentException("Total bytes less than end");
        }
        this.valid = true;
        this.start = start;
        this.end = end;
        this.of = of;
    }

    public long length() {
        return this.end + 1L - this.start;
    }

    public BoundedRange(CharSequence value) {
        value = Strings.trim((CharSequence)value);
        Matcher m = this.RANGE_PATTERN.matcher(value);
        if (m.find()) {
            try {
                this.start = Long.parseLong(m.group(1));
                this.end = Long.parseLong(m.group(2));
                this.of = "*".equals(m.group(3)) ? -1L : Long.parseLong(m.group(3));
                this.valid = this.start < this.end && this.of >= this.end;
            }
            catch (NumberFormatException nfe) {
                this.valid = false;
            }
        } else {
            m = this.INVALID_RANGE_PATTERN.matcher(value);
            if (m.find()) {
                this.start = -1L;
                this.end = -1L;
                try {
                    this.of = Long.parseLong(m.group(1));
                    this.valid = true;
                }
                catch (NumberFormatException nfe) {
                    this.valid = false;
                }
            } else {
                this.valid = false;
                this.start = -1L;
                this.end = -1L;
                this.of = -1L;
            }
        }
    }

    public static BoundedRange unsatisfiable(long availableBytes) {
        return new BoundedRange(-1L, -1L, availableBytes);
    }

    public boolean isRangeNotSatisfiable() {
        return this.start == -1L && this.end == -1L && this.of > 0L;
    }

    public boolean isValid() {
        return this.valid;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long of() {
        return this.of;
    }

    public FileRegion toRegion(File f) {
        return new DefaultFileRegion(f, this.start, this.end + 1L - this.start);
    }

    public CharSequence toCharSequence() {
        if (this.start == -1L && this.end == -1L) {
            AsciiString.of((CharSequence)("bytes */" + this.of));
        }
        return AsciiString.of((CharSequence)("bytes " + this.start + "-" + this.end + "/" + (this.of == -1L ? "*" : Long.valueOf(this.of))));
    }

    public String toString() {
        if (this.start == -1L && this.end == -1L) {
            return "bytes */" + this.of;
        }
        return "bytes " + this.start + "-" + this.end + "/" + (this.of == -1L ? "*" : Long.valueOf(this.of));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BoundedRange) {
            BoundedRange br = (BoundedRange)o;
            return br.start == this.start && br.end == this.end && br.of == this.of;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.start, this.end, this.of});
    }
}

