/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.util.Connection;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;

final class ConnectionHeader
extends AbstractHeader<Connection> {
    private static final AsciiString close = AsciiString.of((CharSequence)Connection.close.toString());
    private static final AsciiString keep_alive = AsciiString.of((CharSequence)Connection.keep_alive.toString());

    ConnectionHeader() {
        super(Connection.class, (CharSequence)HttpHeaderNames.CONNECTION);
    }

    @Override
    public CharSequence toCharSequence(Connection value) {
        Checks.notNull((String)"value", (Object)value);
        switch (value) {
            case close: {
                return close;
            }
            case keep_alive: {
                return keep_alive;
            }
        }
        return value.toString();
    }

    @Override
    public Connection toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        if (Strings.charSequencesEqual((CharSequence)close, (CharSequence)value, (boolean)true)) {
            return Connection.close;
        }
        if (Strings.charSequencesEqual((CharSequence)keep_alive, (CharSequence)value, (boolean)true)) {
            return Connection.keep_alive;
        }
        return null;
    }
}

