/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DurationHeader
extends AbstractHeader<Duration> {
    DurationHeader(CharSequence name) {
        super(Duration.class, name);
    }

    @Override
    public CharSequence toCharSequence(Duration value) {
        Checks.notNull((String)"value", (Object)value);
        return Long.toString(value.getSeconds());
    }

    @Override
    public Duration toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        try {
            return Duration.of(Strings.parseLong((CharSequence)value), ChronoUnit.SECONDS);
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(DurationHeader.class.getName()).log(Level.INFO, "Bad duration header '" + value + "'", nfe);
            return Duration.ZERO;
        }
    }
}

