/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.util.preconditions.Checks;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class KeepAliveHeader
extends AbstractHeader<Duration> {
    private static final Pattern PAT = Pattern.compile(".*?timeout=\\s*?(\\d+)");

    public KeepAliveHeader() {
        super(Duration.class, (CharSequence)new AsciiString((CharSequence)"keep-alive"));
    }

    @Override
    public Duration toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        Matcher m = PAT.matcher(value);
        if (m.find()) {
            String time = m.group(1);
            try {
                long val = Long.parseLong(time);
                return Duration.of(val, ChronoUnit.SECONDS);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid " + this.name() + " header " + value);
            }
        }
        return Duration.ZERO;
    }

    @Override
    public CharSequence toCharSequence(Duration value) {
        Checks.notNull((String)"value", (Object)value);
        return "timeout=" + value.get(ChronoUnit.SECONDS);
    }
}

