/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.util.Set;

final class SetCookieHeader
extends AbstractHeader<Cookie> {
    SetCookieHeader() {
        super(Cookie.class, (CharSequence)HttpHeaderNames.SET_COOKIE);
    }

    @Override
    public String toString(Cookie value) {
        return ServerCookieEncoder.encode((Cookie)value);
    }

    @Override
    public Cookie toValue(CharSequence value) {
        Set ck = CookieDecoder.decode((String)value.toString());
        if (ck.isEmpty()) {
            new NullPointerException("Does not decode to cookies: '" + value + "'").printStackTrace();
            return null;
        }
        return (Cookie)ck.iterator().next();
    }
}

