/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.headers;

import com.mastfrog.acteur.headers.AbstractHeader;
import com.mastfrog.acteur.headers.CharSequenceHeader;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.internal.AppendableCharSequence;

final class VaryHeader
extends AbstractHeader<HeaderValueType[]> {
    VaryHeader() {
        super(HeaderValueType[].class, (CharSequence)HttpHeaderNames.VARY);
    }

    @Override
    public CharSequence toCharSequence(HeaderValueType[] value) {
        Checks.notNull((String)"value", (Object)value);
        if (value.length == 1) {
            return value[0].name();
        }
        AppendableCharSequence seq = new AppendableCharSequence(30);
        for (int i = 0; i < value.length; ++i) {
            seq.append(value[i].name());
            if (i == value.length - 1) continue;
            seq.append((CharSequence)", ");
        }
        return seq;
    }

    @Override
    public HeaderValueType<?>[] toValue(CharSequence value) {
        Checks.notNull((String)"value", (Object)value);
        CharSequence[] s = Strings.split((char)',', (CharSequence)value);
        HeaderValueType[] result = new HeaderValueType[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = new CharSequenceHeader(Strings.trim((CharSequence)s[i]));
        }
        return result;
    }
}

