/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.tests;

import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.DependenciesBuilder;
import com.mastfrog.giulius.tests.GuiceTestException;
import com.mastfrog.giulius.tests.RuleWrapperProvider;
import com.mastfrog.giulius.tests.RunWrapper;
import com.mastfrog.giulius.tests.RunnerFactory;
import com.mastfrog.giulius.tests.TestMethodRunner;
import com.mastfrog.settings.Settings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public abstract class AbstractRunner
extends ParentRunner<TestMethodRunner>
implements RuleWrapperProvider {
    private final List<TestMethodRunner> runners;
    private final RunnerFactory runnerFactory;
    private boolean runnersInitialized;
    private List<RunWrapper> runWrappers = new ArrayList<RunWrapper>();

    protected AbstractRunner(Class<?> testClass, RunnerFactory ... runnerFactories) throws InitializationError {
        super(testClass);
        System.setProperty("unit.test", "true");
        if (runnerFactories == null || runnerFactories.length == 0) {
            throw new IllegalArgumentException("No runner factories");
        }
        this.runnerFactory = new MetaRunnerFactory(runnerFactories);
        this.runnerFactory.setRunner(this);
        this.runners = this.createChildren();
    }

    protected void onBeforeCreateDependencies(TestClass testClass, FrameworkMethod method, Settings settings, DependenciesBuilder builder) {
    }

    protected void onAfterCreateDependencies(TestClass testClass, FrameworkMethod method, Settings settings, Dependencies dependencies) {
    }

    protected Settings onSettingsCreated(Settings settings) {
        return settings;
    }

    protected static TestMethodRunner createJUnitTestMethodRunner(TestClass clazz, FrameworkMethod method, RuleWrapperProvider p, AbstractRunner runner) throws InitializationError {
        return new StandardTestRunner(clazz, method, p, runner);
    }

    public static Exception fakeException(String msg, Class<?> testClass, int positedLineNumber) {
        return new GuiceTestException(msg, testClass, positedLineNumber);
    }

    private final List<TestMethodRunner> createChildren() throws InitializationError {
        TestClass testClass = this.getTestClass();
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        LinkedList<TestMethodRunner> runners = new LinkedList<TestMethodRunner>();
        this.runnerFactory.createChildren(testClass, runners, errors, this);
        if (runners.isEmpty()) {
            errors.add(AbstractRunner.fakeException("No runnable methods", testClass.getJavaClass(), 0));
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
        if (!runners.isEmpty()) {
            ((TestMethodRunner)((Object)runners.get(0))).setFirst(true);
            ((TestMethodRunner)((Object)runners.get(runners.size() - 1))).setLast(true);
        }
        return runners;
    }

    @Override
    public Statement withAfterClasses(Statement statement) {
        return super.withAfterClasses(statement);
    }

    @Override
    public Statement withBeforeClasses(Statement statement) {
        return super.withBeforeClasses(statement);
    }

    @Override
    public Statement classBlock(RunNotifier notifier) {
        return super.classBlock(notifier);
    }

    protected Description describeChild(TestMethodRunner child) {
        return child.getDescription();
    }

    protected List<TestMethodRunner> getChildren() {
        if (!this.runnersInitialized) {
            this.runnersInitialized = true;
            if (!this.runWrappers.isEmpty()) {
                for (int i = 0; i < this.runners.size(); ++i) {
                    TestMethodRunner r = this.runners.get(i);
                    for (RunWrapper rw : this.runWrappers) {
                        if (!rw.match(r.method)) continue;
                        if (r.wrap != null) {
                            throw new AssertionError((Object)"Multiple wrapper runners not supported yet");
                        }
                        r.wrap = rw;
                    }
                    if (r == this.runners.get(i)) continue;
                    this.runners.set(i, r);
                }
            }
        }
        return this.runners;
    }

    protected List<RunWrapper> getWrappersFor(FrameworkMethod meth) {
        ArrayList<RunWrapper> result = new ArrayList<RunWrapper>();
        for (RunWrapper w : this.runWrappers) {
            if (!w.match(meth)) continue;
            result.add(w);
        }
        return result;
    }

    protected void registerRunWrapper(RunWrapper wrapper) {
        this.runWrappers.add(wrapper);
    }

    protected void runChild(TestMethodRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private static class StandardTestRunner
    extends TestMethodRunner {
        StandardTestRunner(TestClass testClass, FrameworkMethod method, RuleWrapperProvider provider, AbstractRunner runner) throws InitializationError {
            super(testClass, method, provider, runner);
        }

        @Override
        protected void invokeTest(Statement base, Object target, Dependencies dependencies) throws Throwable {
            try {
                base.evaluate();
                String prop = System.getProperty("testMethodQname");
                if (prop != null) {
                    System.setProperty(prop + ".failed", "false");
                }
            }
            catch (Throwable t) {
                Test anno = (Test)this.method.getAnnotation(Test.class);
                if (anno.expected() != null && anno.expected().isInstance(t)) {
                    return;
                }
                String prop = System.getProperty("testMethodQname");
                if (prop != null) {
                    System.setProperty(prop + ".failed", "true");
                }
                throw t;
            }
        }
    }

    private static class MetaRunnerFactory
    implements RunnerFactory {
        private final RunnerFactory[] delegateTo;

        MetaRunnerFactory(RunnerFactory ... delegateTo) {
            this.delegateTo = delegateTo;
        }

        @Override
        public void createChildren(TestClass testClass, List<? super TestMethodRunner> runners, List<Throwable> errors, RuleWrapperProvider p) throws InitializationError {
            for (RunnerFactory factory : this.delegateTo) {
                factory.createChildren(testClass, runners, errors, p);
            }
        }

        @Override
        public void setRunner(AbstractRunner runner) {
            for (RunnerFactory factory : this.delegateTo) {
                factory.setRunner(runner);
            }
        }
    }
}

