/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.tests;

import com.mastfrog.giulius.tests.IfBinaryAvailable;
import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.strings.Strings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

final class BinaryChecks {
    private static final String[] DEFAULT_PATHS = new String[]{"/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin"};

    private BinaryChecks() {
        throw new AssertionError();
    }

    private static String[] split(String prop) {
        return Strings.split((char)File.pathSeparatorChar, (String)prop);
    }

    private static String[] splitSystemProperty(String prop, String[] defaultValue) {
        String s = System.getProperty(prop);
        return s == null ? defaultValue : BinaryChecks.split(s);
    }

    private static String[] stringPaths() {
        Object[] all = BinaryChecks.splitSystemProperty("test.binarypaths", DEFAULT_PATHS);
        Object[] more = BinaryChecks.splitSystemProperty("test-additionalbinarypaths", null);
        if (more != null) {
            all = (String[])ArrayUtils.concatenate((Object[])more, (Object[])all);
        }
        return all;
    }

    private static Iterable<? extends Path> paths(String binaryName, String[] alternates) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (String pth : BinaryChecks.stringPaths()) {
            Path p = Paths.get(pth, new String[0]);
            if (!Files.exists(p, new LinkOption[0]) || !Files.isDirectory(p, new LinkOption[0])) continue;
            result.add(p.resolve(pth));
            for (String alt : alternates) {
                result.add(p.resolve(alt));
            }
        }
        return result;
    }

    static boolean isExecutable(String binaryName, String[] alternates) {
        for (Path path : BinaryChecks.paths(binaryName, alternates)) {
            if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !path.toFile().canExecute()) continue;
            return true;
        }
        return false;
    }

    static boolean test(IfBinaryAvailable test) {
        return BinaryChecks.isExecutable(test.value(), test.alternateNames());
    }
}

