/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.tests;

import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.Module;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.DependenciesBuilder;
import com.mastfrog.giulius.tests.AbstractRunner;
import com.mastfrog.giulius.tests.ModuleName;
import com.mastfrog.giulius.tests.RuleWrapperProvider;
import com.mastfrog.giulius.tests.RunnerFactory;
import com.mastfrog.giulius.tests.SkipWhen;
import com.mastfrog.giulius.tests.SkipWhenRunInIDE;
import com.mastfrog.giulius.tests.TestMethodRunner;
import com.mastfrog.giulius.tests.TestWith;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.thread.AutoCloseThreadLocal;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class GuiceRunner
extends AbstractRunner {
    static AutoCloseThreadLocal<String> CURRENT_TEST = new AutoCloseThreadLocal();

    public GuiceRunner(Class<?> testClass) throws InitializationError {
        this(testClass, new DefaultRunnerFactory());
    }

    protected RunnerFactory createDefaultRunnerFactory() {
        return new DefaultRunnerFactory();
    }

    @Override
    protected void onBeforeCreateDependencies(TestClass testClass, FrameworkMethod method, Settings settings, DependenciesBuilder builder) {
        super.onBeforeCreateDependencies(testClass, method, settings, builder);
        System.setProperty("testMethodQname", testClass.getJavaClass().getSimpleName() + '.' + method.getName());
        System.setProperty("testMethod", method.getName());
        System.setProperty("testClass", testClass.getName());
    }

    protected GuiceRunner(Class<?> testClass, RunnerFactory ... runnerFactories) throws InitializationError {
        super(testClass, runnerFactories);
    }

    public void run(RunNotifier notifier) {
        Statement st = this.classBlock(notifier);
        try {
            st.evaluate();
        }
        catch (Throwable ex) {
            notifier.fireTestFailure(new Failure(this.getDescription(), ex));
        }
    }

    protected static void validateModuleClassesCanBeConstructed(List<Class<?>> types, List<Throwable> errors) {
        for (Class<?> c : types) {
            Constructor<?> con = GuiceRunner.findUsableModuleConstructor(c);
            if (con != null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(c.getName()).append("must have a constructor with the signature '").append(c.getSimpleName()).append("()' or '").append(c.getSimpleName()).append("(Settings settings)'.  The constructor need not be public, but must exist.");
            errors.add(GuiceRunner.fakeException(sb.toString(), c, 0));
        }
    }

    protected static void checkOverlap(FrameworkMethod m, TestWith anno, List<Throwable> errors) {
        List a = GuiceRunner.collectClasses(anno, errors);
        List<Class<?>> b = GuiceRunner.collectClasses((TestWith)m.getAnnotation(TestWith.class), errors);
        if (a == null || b == null) {
            return;
        }
        HashSet set = new HashSet();
        set.addAll(a);
        set.addAll(b);
        if (set.size() != a.size() + b.size()) {
            a.addAll(b);
            a.removeAll(set);
            errors.add(new IllegalArgumentException("Class and method both want to create an instance of the same module(s): " + a));
        }
    }

    protected static List<Class<?>> collectClasses(TestWith anno, List<Throwable> errors) {
        if (anno != null) {
            LinkedList result = new LinkedList();
            result.addAll(Arrays.asList(anno.value()));
            result.addAll(Arrays.asList(anno.iterate()));
            GuiceRunner.validateModuleClassesCanBeConstructed(result, errors);
            return result;
        }
        return null;
    }

    static Constructor<?> findUsableModuleConstructor(Class<?> type) {
        Constructor<?> con = null;
        try {
            con = type.getDeclaredConstructor(Settings.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return con;
    }

    public static String currentMethodName() {
        String fm = (String)CURRENT_TEST.get();
        if (fm != null) {
            return fm;
        }
        return "<no current test>";
    }

    static class IterativeGuiceTestRunner
    extends GuiceTestRunner {
        private final int indexInClassAnnotation;
        private final int indexInMethodAnnotation;

        public IterativeGuiceTestRunner(int indexInClassAnnotation, int indexInMethodAnnotation, TestClass testClass, FrameworkMethod method, RuleWrapperProvider p, AbstractRunner runner) throws InitializationError {
            super(testClass, method, p, runner);
            this.indexInClassAnnotation = indexInClassAnnotation;
            this.indexInMethodAnnotation = indexInMethodAnnotation;
            TestWith classAnnotation = testClass.getJavaClass().getAnnotation(TestWith.class);
            TestWith methodAnnotation = (TestWith)method.getAnnotation(TestWith.class);
            this.checkAnnotationSettingsArguments(classAnnotation);
            this.checkAnnotationSettingsArguments(methodAnnotation);
        }

        private void checkAnnotationSettingsArguments(TestWith anno) {
            if (anno == null) {
                return;
            }
            int iterCount = anno.iterate().length;
            int settingsCount = anno.iterateSettings().length;
            if (iterCount == 0 && settingsCount != 0) {
                throw new AssertionError((Object)"iterateSettings= is meaningless if iterate= not set");
            }
            if (iterCount > 0 && settingsCount != 0 && settingsCount != iterCount) {
                throw new AssertionError((Object)"If both iterate= and iterateSettings= are set, they must have the same number of arguments");
            }
        }

        public static String nameOf(Class<? extends Module> moduleClass) {
            ModuleName mn = moduleClass.getAnnotation(ModuleName.class);
            return mn == null ? moduleClass.getSimpleName() : mn.value();
        }

        private List<String> parseSettingsValue(String value) {
            ArrayList<String> result = new ArrayList<String>();
            for (String s : value.split(",")) {
                result.add(s.trim());
            }
            return result;
        }

        @Override
        protected void onAfterComputeSettingsLocations(List<String> locations) {
            String[] mSettings;
            TestWith classAnnotation = this.testClass.getJavaClass().getAnnotation(TestWith.class);
            TestWith methodAnnotation = (TestWith)this.method.getAnnotation(TestWith.class);
            String[] cSettings = classAnnotation == null ? new String[]{} : classAnnotation.iterateSettings();
            String[] stringArray = mSettings = methodAnnotation == null ? new String[]{} : methodAnnotation.iterateSettings();
            if (cSettings.length + mSettings.length > 0) {
                if (cSettings.length != 0) {
                    locations.addAll(this.parseSettingsValue(cSettings[this.indexInClassAnnotation]));
                }
                if (mSettings.length != 0) {
                    locations.addAll(this.parseSettingsValue(mSettings[this.indexInMethodAnnotation]));
                }
            }
            super.onAfterComputeSettingsLocations(locations);
        }

        public String toString() {
            TestWith methodAnnotation;
            Class<? extends Module> moduleClass;
            TestWith classAnnotation;
            StringBuilder result = new StringBuilder();
            if (this.indexInClassAnnotation >= 0 && (classAnnotation = this.testClass.getJavaClass().getAnnotation(TestWith.class)) != null) {
                moduleClass = classAnnotation.iterate()[this.indexInClassAnnotation];
                result.append(IterativeGuiceTestRunner.nameOf(moduleClass));
            }
            if (this.indexInMethodAnnotation >= 0 && (methodAnnotation = (TestWith)this.method.getAnnotation(TestWith.class)) != null) {
                moduleClass = methodAnnotation.iterate()[this.indexInMethodAnnotation];
                if (result.length() > 1) {
                    result.append(",");
                }
                result.append(IterativeGuiceTestRunner.nameOf(moduleClass));
            }
            return result.toString();
        }

        @Override
        protected Description describeChild(Description origDescription) {
            return Description.createTestDescription((Class)this.testClass.getJavaClass(), (String)(this.toString() + "__" + origDescription.getMethodName()));
        }

        @Override
        protected boolean skip() {
            boolean result = super.skip();
            System.out.println("test method " + this.method.getName());
            if (!result) {
                TestWith methodAnnotation;
                TestWith classAnnotation = this.testClass.getJavaClass().getAnnotation(TestWith.class);
                if (classAnnotation != null && this.indexInClassAnnotation != -1) {
                    Class<? extends Module> iteration = classAnnotation.iterate()[this.indexInClassAnnotation];
                    if (iteration.getAnnotation(SkipWhenRunInIDE.class) != null) {
                        result |= Dependencies.isIDEMode();
                    }
                    SkipWhen condition = iteration.getAnnotation(SkipWhen.class);
                    result |= TestMethodRunner.shouldSkip(condition);
                }
                if ((methodAnnotation = (TestWith)this.method.getAnnotation(TestWith.class)) != null && this.indexInMethodAnnotation != -1) {
                    Class<? extends Module> iteration = methodAnnotation.iterate()[this.indexInMethodAnnotation];
                    if (iteration.getAnnotation(SkipWhenRunInIDE.class) != null) {
                        result |= Dependencies.isIDEMode();
                    }
                    SkipWhen condition = iteration.getAnnotation(SkipWhen.class);
                    result |= TestMethodRunner.shouldSkip(condition);
                }
            }
            return result;
        }

        @Override
        protected List<Class<? extends Module>> findModuleClasses() {
            TestWith methodAnnotation;
            Class<? extends Module> iteration;
            TestWith classAnnotation;
            List<Class<? extends Module>> result = super.findModuleClasses();
            if (this.indexInClassAnnotation >= 0 && (classAnnotation = this.testClass.getJavaClass().getAnnotation(TestWith.class)) != null) {
                iteration = classAnnotation.iterate()[this.indexInClassAnnotation];
                result.add(iteration);
            }
            if (this.indexInMethodAnnotation >= 0 && (methodAnnotation = (TestWith)this.method.getAnnotation(TestWith.class)) != null) {
                iteration = methodAnnotation.iterate()[this.indexInMethodAnnotation];
                result.add(iteration);
            }
            return result;
        }
    }

    static class GuiceTestRunner
    extends TestMethodRunner {
        public GuiceTestRunner(TestClass testClass, FrameworkMethod method, RuleWrapperProvider prov, AbstractRunner runner) throws InitializationError {
            super(testClass, method, prov, runner);
        }

        @Override
        protected void invokeTest(Statement base, final Object target, final Dependencies dependencies) throws Throwable {
            final Type[] paramTypes = this.method.getMethod().getGenericParameterTypes();
            Test test = (Test)this.method.getAnnotation(Test.class);
            TestWith testWith = (TestWith)this.method.getAnnotation(TestWith.class);
            final boolean shouldThrowException = test != null && !"None".equals(test.expected().getSimpleName()) || testWith != null && !"None".equals(testWith.expected().getSimpleName());
            try {
                CURRENT_TEST.set((Object)((Object)((Object)this) + "__" + this.method.getName()));
                if (paramTypes.length == 0) {
                    base.evaluate();
                    if (shouldThrowException) {
                        throw new AssertionError((Object)(this.method.getMethod().getName() + " should have thrown an exception but did not"));
                    }
                } else {
                    final Statement st = new Statement(){

                        public void evaluate() throws Throwable {
                            Object[] parameters = new Object[paramTypes.length];
                            Annotation[][] a = method.getMethod().getParameterAnnotations();
                            for (int i = 0; i < paramTypes.length; ++i) {
                                try {
                                    Key key;
                                    if (a[i].length > 0) {
                                        if (a[i].length > 1) {
                                            throw new AssertionError((Object)("Multiple annotations on test method parameter " + paramTypes[i] + ": " + Arrays.asList(a[i]) + " but Guice's Key.get() only allows one"));
                                        }
                                        key = Key.get((Type)paramTypes[i], (Annotation)a[i][0]);
                                    } else {
                                        key = Key.get((Type)paramTypes[i]);
                                    }
                                    parameters[i] = dependencies.getInstance(key);
                                    continue;
                                }
                                catch (ConfigurationException e) {
                                    throw new IllegalStateException("Guice configuration exception creating parameter of type " + paramTypes[i] + " for " + method.getName() + " on " + target.getClass().getName(), e);
                                }
                            }
                            method.invokeExplosively(target, parameters);
                            if (shouldThrowException) {
                                throw AbstractRunner.fakeException(method.getMethod().getName() + " should have thrown an exception but did not", testClass.getJavaClass(), 0);
                            }
                        }
                    };
                    Statement beforeAfter = new Statement(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void evaluate() throws Throwable {
                            List befores = testClass.getAnnotatedMethods(Before.class);
                            List afters = testClass.getAnnotatedMethods(After.class);
                            for (FrameworkMethod m : befores) {
                                m.invokeExplosively(target, new Object[0]);
                            }
                            try {
                                st.evaluate();
                            }
                            finally {
                                for (FrameworkMethod m : afters) {
                                    m.invokeExplosively(target, new Object[0]);
                                }
                            }
                        }
                    };
                    beforeAfter.evaluate();
                }
            }
            catch (Throwable t) {
                if (test != null && (test.expected().isInstance(t) || t.getCause() != null && test.expected().isInstance(t.getCause()))) {
                    return;
                }
                if (testWith != null && (testWith.expected().isInstance(t) || t.getCause() != null && testWith.expected().isInstance(t.getCause()))) {
                    return;
                }
                throw t;
            }
            finally {
                CURRENT_TEST.set(null);
            }
        }
    }

    static class DefaultRunnerFactory
    implements RunnerFactory {
        private AbstractRunner runner;

        DefaultRunnerFactory() {
        }

        @Override
        public void createChildren(TestClass testClass, List<? super TestMethodRunner> runners, List<Throwable> errors, RuleWrapperProvider p) throws InitializationError {
            TestWith classAnnotation = testClass.getJavaClass().getAnnotation(TestWith.class);
            if (classAnnotation != null && !"None".equals(classAnnotation.expected().getSimpleName())) {
                errors.add((Throwable)((Object)new AssertionError((Object)"expected= is meaningless on class annotation")));
            }
            ArrayList standardTestMethods = new ArrayList();
            ArrayList guiceTestMethods = new ArrayList();
            guiceTestMethods.addAll(testClass.getAnnotatedMethods(TestWith.class));
            standardTestMethods.addAll(testClass.getAnnotatedMethods(Test.class));
            for (FrameworkMethod m : standardTestMethods) {
                if (m.getAnnotation(TestWith.class) != null) {
                    throw new IllegalArgumentException(m.getName() + " has both @Test and @TestWith annotations.  This is illegal.");
                }
                GuiceRunner.checkOverlap(m, classAnnotation, errors);
                if (classAnnotation == null || classAnnotation.iterate().length == 0) {
                    if (m.getMethod().getGenericParameterTypes().length == 0) {
                        runners.add(AbstractRunner.createJUnitTestMethodRunner(testClass, m, p, this.runner));
                        continue;
                    }
                    runners.add(new GuiceTestRunner(testClass, m, p, this.runner));
                    continue;
                }
                for (int i = 0; i < classAnnotation.iterate().length; ++i) {
                    runners.add(new IterativeGuiceTestRunner(i, -1, testClass, m, p, this.runner));
                }
            }
            for (FrameworkMethod m : guiceTestMethods) {
                int i;
                GuiceRunner.checkOverlap(m, classAnnotation, errors);
                TestWith methodAnnotation = (TestWith)m.getAnnotation(TestWith.class);
                if (classAnnotation == null && methodAnnotation != null) {
                    if (methodAnnotation.iterate().length == 0) {
                        runners.add(new GuiceTestRunner(testClass, m, p, this.runner));
                        continue;
                    }
                    for (i = 0; i < methodAnnotation.iterate().length; ++i) {
                        runners.add(new IterativeGuiceTestRunner(-1, i, testClass, m, p, this.runner));
                    }
                    continue;
                }
                if (classAnnotation != null && methodAnnotation == null) {
                    if (classAnnotation.iterate().length == 0) {
                        runners.add(new GuiceTestRunner(testClass, m, p, this.runner));
                        continue;
                    }
                    for (i = 0; i < classAnnotation.iterate().length; ++i) {
                        runners.add(new IterativeGuiceTestRunner(i, -1, testClass, m, p, this.runner));
                    }
                    continue;
                }
                if (classAnnotation != null && methodAnnotation != null) {
                    if (classAnnotation.iterate().length == 0 && methodAnnotation.iterate().length == 0) {
                        runners.add(new GuiceTestRunner(testClass, m, p, this.runner));
                        continue;
                    }
                    if (classAnnotation.iterate().length > 0 && methodAnnotation.iterate().length == 0) {
                        for (i = 0; i < classAnnotation.iterate().length; ++i) {
                            runners.add(new IterativeGuiceTestRunner(i, -1, testClass, m, p, this.runner));
                        }
                        continue;
                    }
                    if (classAnnotation.iterate().length == 0 && methodAnnotation.iterate().length > 0) {
                        for (i = 0; i < methodAnnotation.iterate().length; ++i) {
                            runners.add(new IterativeGuiceTestRunner(-1, i, testClass, m, p, this.runner));
                        }
                        continue;
                    }
                    if (classAnnotation.iterate().length > 0 && methodAnnotation.iterate().length > 0) {
                        for (i = 0; i < classAnnotation.iterate().length; ++i) {
                            for (int j = 0; j < methodAnnotation.iterate().length; ++j) {
                                runners.add(new IterativeGuiceTestRunner(i, j, testClass, m, p, this.runner));
                            }
                        }
                        continue;
                    }
                    throw new AssertionError((Object)("Should not get here: " + classAnnotation + " : " + methodAnnotation));
                }
                throw new AssertionError((Object)"Processing a method for Guice but there is not such annotation. ??");
            }
        }

        @Override
        public void setRunner(AbstractRunner runner) {
            this.runner = runner;
        }
    }
}

