/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.tests;

import com.mastfrog.util.streams.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class NetworkCheck {
    private final String host;
    private static final long TWO_MINUTES = 120000L;
    private File networkTestResult;
    private AtomicReference<Boolean> lastResult = new AtomicReference();
    private static final long TIMEOUT = 30000L;
    private final boolean useHttp;

    NetworkCheck(String host, boolean useHttp) {
        this.host = host;
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        assert (tmp.exists() && tmp.isDirectory());
        this.networkTestResult = new File(tmp, host + "." + this.getClass().getSimpleName());
        this.useHttp = useHttp;
    }

    NetworkCheck() {
        this("google.com", true);
    }

    public synchronized void reset() {
        this.lastResult.set(null);
        if (this.networkTestResult.exists()) {
            for (int i = 0; i < 10 && !this.networkTestResult.delete() && this.networkTestResult.exists(); ++i) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
    }

    public synchronized boolean isNetworkAvailable() {
        boolean result;
        try {
            if (this.shouldRecheck()) {
                boolean result2 = this.performNetworkCheckAndSaveResult();
                this.lastResult.set(result2);
                return result2;
            }
            Boolean b = this.lastResult.get();
            if (b != null) {
                result = b;
            } else {
                result = this.readFromFile();
                this.lastResult.set(result);
            }
        }
        catch (IOException ioe) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("NetworkCheck {");
        sb.append(this.host);
        sb.append(" lastResult=").append(this.lastResult);
        sb.append(" shouldRecheck? ").append(this.shouldRecheck());
        if (this.networkTestResult.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.networkTestResult);
                String s = Streams.readString((InputStream)in);
                sb.append(" FileContents=").append(s);
            }
            catch (IOException e) {
                Logger.getLogger(NetworkCheck.class.getName()).log(Level.FINEST, null, e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NetworkCheck.class.getName()).log(Level.FINEST, null, ex);
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readFromFile() throws IOException {
        boolean result;
        if (!this.networkTestResult.exists()) {
            return this.performNetworkCheckAndSaveResult();
        }
        try (FileInputStream in = new FileInputStream(this.networkTestResult);){
            int val = in.read();
            result = val == 111;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(boolean value) throws IOException {
        if (!this.networkTestResult.exists()) {
            for (int i = 0; i < 10 && !this.networkTestResult.createNewFile(); ++i) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
        FileOutputStream out = new FileOutputStream(this.networkTestResult);
        try {
            out.write(value ? "ok".getBytes("US-ASCII") : "fail".getBytes("US-ASCII"));
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private boolean performNetworkCheckAndSaveResult() throws IOException {
        boolean result;
        try {
            InetAddress addr = InetAddress.getByName(this.host);
            if (!this.useHttp) {
                result = addr.isReachable(30000);
            } else {
                Socket socket = SocketFactory.getDefault().createSocket(addr, 80);
                OutputStream out = socket.getOutputStream();
                out.close();
                result = true;
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(NetworkCheck.class.getName()).log(Level.FINE, null, ioe);
            result = false;
        }
        this.writeToFile(result);
        return result;
    }

    private boolean shouldRecheck() {
        boolean needRecheck;
        long lastActualNetworkCheck = this.networkTestResult.exists() ? this.networkTestResult.lastModified() : -1L;
        boolean bl = needRecheck = System.currentTimeMillis() - 120000L < lastActualNetworkCheck;
        if (needRecheck) {
            this.lastResult.set(null);
        }
        return needRecheck;
    }
}

