/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.tests;

import com.mastfrog.giulius.Dependencies;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class RunWrapper {
    private final Class<? extends Annotation> annotationClass;

    protected RunWrapper(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
        Retention r = annotationClass.getAnnotation(Retention.class);
        if (r == null) {
            throw new AssertionError((Object)(annotationClass + " has no retention and will not be found at runtime"));
        }
        RetentionPolicy p = r.value();
        if (p != RetentionPolicy.RUNTIME) {
            throw new AssertionError((Object)(annotationClass + " does not have RetentionPolicy=RUNTIME, so the test harness will never see it"));
        }
        Target tgt = annotationClass.getAnnotation(Target.class);
        if (tgt != null && !Arrays.asList(tgt.value()).contains((Object)ElementType.METHOD)) {
            throw new AssertionError((Object)(annotationClass + " does not have a target of METHOD"));
        }
    }

    boolean match(FrameworkMethod method) {
        boolean result = method.getAnnotation(this.annotationClass) != null;
        return result;
    }

    protected abstract void invokeTest(Statement var1, Object var2, FrameworkMethod var3, Dependencies var4) throws Throwable;
}

