/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.tests;

import com.google.inject.Key;
import com.google.inject.Module;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.DependenciesBuilder;
import com.mastfrog.giulius.tests.AbstractRunner;
import com.mastfrog.giulius.tests.BinaryChecks;
import com.mastfrog.giulius.tests.Configurations;
import com.mastfrog.giulius.tests.GuiceRunner;
import com.mastfrog.giulius.tests.IfBinaryAvailable;
import com.mastfrog.giulius.tests.InjectingRunner;
import com.mastfrog.giulius.tests.NetworkCheck;
import com.mastfrog.giulius.tests.OnInjection;
import com.mastfrog.giulius.tests.RuleWrapperProvider;
import com.mastfrog.giulius.tests.RunWrapper;
import com.mastfrog.giulius.tests.SkipWhen;
import com.mastfrog.giulius.tests.SkipWhenNetworkUnavailable;
import com.mastfrog.giulius.tests.SkipWhenRunInIDE;
import com.mastfrog.giulius.tests.TestWith;
import com.mastfrog.settings.MutableSettings;
import com.mastfrog.settings.Settings;
import com.mastfrog.settings.SettingsBuilder;
import com.mastfrog.util.streams.Streams;
import com.mastfrog.util.strings.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public abstract class TestMethodRunner
extends Runner
implements MethodRule {
    protected final TestClass testClass;
    protected final FrameworkMethod method;
    private final InjectingRunner actualRunner;
    RunWrapper wrap;
    protected static final NetworkCheck NETWORK_CHECK = new NetworkCheck("google.com", true);
    protected final RuleWrapperProvider ruleWrapper;
    private final AbstractRunner guiceRunner;
    public static final String TESTS_HOME_SETTINGS_OVERRIDE_DIR_SYSTEM_PROPERTY = "guice.test.settings.overrides.dir";
    public static final String TESTS_DEFAULT_HOME_SETTINGS_OVERRIDE_DIR = "tests";
    public static final String TESTS_HOME_SETTINGS_FILE_NAME_SYSTEM_PROPERTY = "guice.test.properties.file";
    public static final String TESTS_DEFAULT_HOME_SETTINGS_FILE_NAME = "tests.properties";
    private static boolean skipHomeDir = Boolean.getBoolean("guice.test.dont.read.from.user.home");
    private boolean first;
    private boolean last;

    protected TestMethodRunner(TestClass testClass, FrameworkMethod method, RuleWrapperProvider p, AbstractRunner guiceRunner) throws InitializationError {
        this.testClass = testClass;
        this.method = method;
        this.actualRunner = new InjectingRunner(testClass.getJavaClass(), this);
        this.ruleWrapper = p;
        this.guiceRunner = guiceRunner;
    }

    public final void run(RunNotifier notifier) {
        this.actualRunner.runChild(this.method, notifier);
    }

    public Description getDescription() {
        return this.actualRunner.getDescription();
    }

    private static void log(CharSequence what) {
        if (Boolean.getBoolean("giulius.tests.verbose")) {
            System.err.println(what);
        }
    }

    static boolean shouldSkip(SkipWhen condition) {
        boolean result;
        if (condition == null) {
            result = false;
        } else {
            String checkFor = condition.value();
            boolean invert = condition.invert();
            String val = System.getProperty(checkFor, System.getenv(checkFor));
            if (val == null) {
                val = System.getenv(checkFor.toUpperCase().replace('.', '_'));
            }
            if (val != null) {
                switch (val.toLowerCase().trim()) {
                    case "true": 
                    case "1": 
                    case "yes": {
                        result = !invert;
                        break;
                    }
                    default: {
                        result = invert;
                        break;
                    }
                }
            } else {
                result = invert;
            }
        }
        return result;
    }

    static boolean shouldSkip(TestClass testClass, FrameworkMethod method) {
        boolean result;
        boolean inIDE = Dependencies.isIDEMode();
        boolean bl = result = inIDE && (testClass.getJavaClass().getAnnotation(SkipWhenRunInIDE.class) != null || method.getAnnotation(SkipWhenRunInIDE.class) != null);
        if (!(result || testClass.getJavaClass().getAnnotation(SkipWhenNetworkUnavailable.class) == null && method.getAnnotation(SkipWhenNetworkUnavailable.class) == null)) {
            boolean bl2 = result = !NETWORK_CHECK.isNetworkAvailable();
            if (!result) {
                TestMethodRunner.log("Skip " + testClass.getName() + "." + method.getName() + " due to network unavailability");
            }
        }
        if (!result) {
            SkipWhen condition = testClass.getJavaClass().getAnnotation(SkipWhen.class);
            if (condition == null) {
                condition = (SkipWhen)method.getAnnotation(SkipWhen.class);
            }
            result = TestMethodRunner.shouldSkip(condition);
        }
        if (!result) {
            IfBinaryAvailable avail = testClass.getJavaClass().getAnnotation(IfBinaryAvailable.class);
            if (avail == null) {
                avail = (IfBinaryAvailable)method.getAnnotation(IfBinaryAvailable.class);
            }
            if (avail != null) {
                boolean bl3 = result = !BinaryChecks.test(avail);
                if (result) {
                    TestMethodRunner.log("Binary '" + avail.value() + "' not found - skipping " + testClass.getName() + "." + method.getName());
                }
            }
        }
        return result;
    }

    protected boolean skip() {
        return TestMethodRunner.shouldSkip(this.testClass, this.method);
    }

    protected void collectModuleClasses(TestWith annotation, List<Class<? extends Module>> classes) {
        if (annotation != null) {
            classes.addAll(Arrays.asList(annotation.value()));
        }
    }

    protected List<Class<? extends Module>> findModuleClasses() {
        LinkedList<Class<? extends Module>> result = new LinkedList<Class<? extends Module>>();
        this.collectModuleClasses(this.testClass.getJavaClass().getAnnotation(TestWith.class), result);
        this.collectModuleClasses((TestWith)this.method.getAnnotation(TestWith.class), result);
        return result;
    }

    protected void onBeforeComputeSettingsLocations(List<? super String> locations) {
        File testSettings;
        File homeDir;
        String home;
        if (skipHomeDir) {
            return;
        }
        String propsFileName = System.getProperty(TESTS_HOME_SETTINGS_FILE_NAME_SYSTEM_PROPERTY);
        if (propsFileName == null) {
            propsFileName = TESTS_DEFAULT_HOME_SETTINGS_FILE_NAME;
        }
        if ((home = System.getProperty("user.home")) != null && (homeDir = new File(home)).exists() && (testSettings = new File(homeDir, propsFileName)).exists()) {
            try {
                String url = testSettings.getAbsoluteFile().toURI().toURL().toExternalForm();
                locations.add(url);
            }
            catch (MalformedURLException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    protected void onAfterComputeSettingsLocations(List<String> locations) {
        File dir;
        File homeDir;
        String home;
        if (skipHomeDir) {
            return;
        }
        String propsDirName = System.getProperty(TESTS_HOME_SETTINGS_OVERRIDE_DIR_SYSTEM_PROPERTY);
        if (propsDirName == null) {
            propsDirName = TESTS_DEFAULT_HOME_SETTINGS_OVERRIDE_DIR;
        }
        if ((home = System.getProperty("user.home")) != null && (homeDir = new File(home)).exists() && (dir = new File(homeDir, propsDirName)).exists() && dir.isDirectory()) {
            String[] locs;
            for (String path : locs = locations.toArray(new String[locations.size()])) {
                File f = new File(dir, path.replace('/', File.separatorChar));
                if (!f.exists()) continue;
                try {
                    locations.add(f.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(TestMethodRunner.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private String[] settingsLocations() {
        Class<?> tc;
        LinkedList<String> locations = new LinkedList<String>();
        Class<?> outer = tc = this.testClass.getJavaClass();
        while (outer.getEnclosingClass() != null) {
            outer = outer.getEnclosingClass();
        }
        String siblingPropertiesName = outer.getSimpleName() + ".properties";
        if (outer.getResource(siblingPropertiesName) != null) {
            String qname = outer.getName().replace('.', '/') + ".properties";
            locations.add(qname);
        }
        this.onBeforeComputeSettingsLocations(locations);
        Configurations locs = this.testClass.getJavaClass().getAnnotation(Configurations.class);
        if (locs != null) {
            locations.addAll(Arrays.asList(locs.value()));
        }
        if ((locs = (Configurations)this.method.getAnnotation(Configurations.class)) != null) {
            locations.addAll(Arrays.asList(locs.value()));
        }
        this.onAfterComputeSettingsLocations(locations);
        return locations.toArray(new String[0]);
    }

    private Module[] createModules(Settings settings) throws Throwable {
        LinkedList<Module> result = new LinkedList<Module>();
        for (Class<? extends Module> type : this.findModuleClasses()) {
            result.add(this.instantiateModule(type, settings));
        }
        return result.toArray(new Module[0]);
    }

    protected final Settings loadSettings() throws Throwable {
        SettingsBuilder sb = SettingsBuilder.createDefault();
        Object[] settingsLocations = this.settingsLocations();
        TestMethodRunner.log("Loading Settings from the following locations for " + this.getDescription() + " " + this.method.getName());
        TestMethodRunner.log(Strings.toString((Object[])settingsLocations));
        for (Object loc : settingsLocations) {
            if (Streams.locate((String)loc) == null) {
                throw GuiceRunner.fakeException("No such settings file: " + (String)loc, this.testClass.getJavaClass(), 0);
            }
            sb.add((String)loc);
        }
        Settings settings = sb.build();
        if (Boolean.getBoolean("guice.tests.debug")) {
            TestMethodRunner.log("SETTINGS ARE " + settings);
        }
        if (this.guiceRunner != null) {
            settings = this.guiceRunner.onSettingsCreated(settings);
        }
        return settings;
    }

    protected final Dependencies createDependencies() throws Throwable {
        Settings settings = this.onSettingsCreated(this.loadSettings());
        Module[] modules = this.createModules(settings);
        if (modules.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Module m : modules) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                Class<?> type = m.getClass();
                sb.append(GuiceRunner.IterativeGuiceTestRunner.nameOf(type));
            }
            TestMethodRunner.log("Instantiated the following modules for :" + this.testClass.getName() + "." + this.method.getName());
            TestMethodRunner.log(sb);
        } else {
            TestMethodRunner.log("No modules requred for " + this.testClass.getName() + "." + this.method.getName());
        }
        DependenciesBuilder builder = Dependencies.builder().useMutableSettings();
        builder.addDefaultSettings();
        if (!Collections.singleton("defaults").equals(builder.namespaces())) {
            TestMethodRunner.log("\nNAMESPACES: " + builder.namespaces());
        }
        for (String ns : builder.namespaces()) {
            builder.add(settings, ns);
        }
        builder.add(modules);
        this.onBeforeCreateDependencies(settings, builder);
        Dependencies dependencies = builder.build();
        this.onAfterCreateDependencies(settings, dependencies);
        return dependencies;
    }

    protected Settings onSettingsCreated(Settings orig) throws IOException {
        MutableSettings mutable = new SettingsBuilder().buildMutableSettings();
        String prefix = "override.";
        boolean hasOverrides = false;
        for (String prop : System.getProperties().stringPropertyNames()) {
            if (!prop.startsWith(prefix) || prop.length() <= prefix.length()) continue;
            String name = prop.substring(prefix.length());
            String val = System.getProperty(prop);
            TestMethodRunner.log("Setting override: " + name + "=" + val);
            hasOverrides = true;
            mutable.setString(name, val);
        }
        if (hasOverrides) {
            SettingsBuilder b = new SettingsBuilder();
            b.add(orig);
            b.add((Settings)mutable);
            orig = b.build();
        }
        return orig;
    }

    protected void onBeforeCreateDependencies(Settings settings, DependenciesBuilder builder) {
        if (this.guiceRunner != null) {
            this.guiceRunner.onBeforeCreateDependencies(this.testClass, this.method, settings, builder);
        }
    }

    protected void onAfterCreateDependencies(Settings settings, Dependencies dependencies) {
        if (this.guiceRunner != null) {
            this.guiceRunner.onAfterCreateDependencies(this.testClass, this.method, settings, dependencies);
        }
    }

    private Module instantiateModule(Class<? extends Module> moduleClass, Settings settings) throws Throwable {
        Module module;
        Constructor<?> c = GuiceRunner.findUsableModuleConstructor(moduleClass);
        TestMethodRunner.log("Will construct module " + moduleClass.getName() + " using " + c);
        c.setAccessible(true);
        if (c.getParameterTypes().length == 1) {
            module = (Module)c.newInstance(settings);
        } else if (c.getParameterTypes().length == 0) {
            module = (Module)c.newInstance(new Object[0]);
        } else {
            throw new AssertionError((Object)("Should have rejected module class " + moduleClass.getName() + "with constructor arguments which are not empty or a single Settings object"));
        }
        return module;
    }

    void setFirst(boolean first) {
        this.first = first;
    }

    void setLast(boolean last) {
        this.last = last;
    }

    protected final boolean isFirst() {
        return this.first;
    }

    protected final boolean isLast() {
        return this.last;
    }

    public final Statement apply(Statement base, final FrameworkMethod method, Object target) {
        if (this.skip()) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    TestMethodRunner.log("Skipping " + method.getName() + " in IDE mode");
                }
            };
        }
        Statement doIt = this.createStatement(base, target);
        return doIt;
    }

    protected static Object[] argumentsForMethod(Method m, Dependencies dependencies) {
        Type[] types = m.getGenericParameterTypes();
        Object[] args = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            args[i] = dependencies.getInstance(Key.get((Type)type));
        }
        return args;
    }

    Statement createStatement(final Statement base, final Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                final Dependencies dependencies = TestMethodRunner.this.createDependencies();
                try {
                    dependencies.injectMembers(target);
                    for (FrameworkMethod m : TestMethodRunner.this.testClass.getAnnotatedMethods(OnInjection.class)) {
                        m.getMethod().setAccessible(true);
                        if (m.getMethod().getParameterTypes().length == 1 && m.getMethod().getParameterTypes()[0] == Dependencies.class) {
                            m.invokeExplosively(target, new Object[]{dependencies});
                            continue;
                        }
                        if (m.getMethod().getParameterTypes().length == 0) {
                            m.invokeExplosively(target, new Object[0]);
                            continue;
                        }
                        m.invokeExplosively(target, TestMethodRunner.argumentsForMethod(m.getMethod(), dependencies));
                    }
                    if (TestMethodRunner.this.wrap != null) {
                        Statement doIt = new Statement(){

                            public void evaluate() throws Throwable {
                                TestMethodRunner.this.invokeTest(base, target, dependencies);
                            }
                        };
                        TestMethodRunner.this.wrap.invokeTest(doIt, target, TestMethodRunner.this.method, dependencies);
                    } else {
                        Statement b = base;
                        TestMethodRunner.this.invokeTest(b, target, dependencies);
                    }
                }
                finally {
                    dependencies.shutdown();
                }
            }
        };
    }

    protected abstract void invokeTest(Statement var1, Object var2, Dependencies var3) throws Throwable;

    protected Description describeChild(Description origDescription) {
        return origDescription;
    }
}

