/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.scope;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import com.mastfrog.function.throwing.ThrowingFunction;
import com.mastfrog.giulius.scope.ScopeRunner;
import com.mastfrog.giulius.scope.ScopedThreadPool;
import com.mastfrog.util.strings.AlignedText;
import com.mastfrog.util.thread.QuietAutoCloseable;
import java.lang.annotation.Annotation;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public abstract class AbstractScope
implements Scope {
    private final Set<Class<?>> types = new HashSet();
    private final Set<Class<?>> nullableTypes = new HashSet();
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Provider<String> injectionInfoProvider;
    protected volatile boolean includeStackTraces = false;

    public AbstractScope() {
        this((Provider<String>)Providers.of((Object)""));
    }

    public AbstractScope(Provider<String> injectionInfoProvider) {
        this.injectionInfoProvider = injectionInfoProvider;
    }

    public Set<Class<?>> allTypes() {
        HashSet result = new HashSet();
        result.addAll(this.types);
        result.addAll(this.nullableTypes);
        return Collections.unmodifiableSet(result);
    }

    protected void bind(Binder binder, Class<?> ... types) {
        this.bind(null, binder, types);
    }

    protected void bind(Class<? extends Annotation> scopeAnnotationType, Binder binder, Class<?> ... types) {
        if (scopeAnnotationType != null) {
            binder.bindScope(scopeAnnotationType, (Scope)this);
        }
        for (Class<?> type : types) {
            this.bindInScope(binder, type);
            this.types.add(type);
        }
    }

    protected void bindAllowingNulls(Binder binder, Class<?> ... types) {
        for (Class<?> type : types) {
            this.bindInScopeAllowingNulls(binder, type);
            this.nullableTypes.add(type);
        }
    }

    public ScopeRunner runner(Injector inj) {
        return new ScopeRunner(inj, this);
    }

    protected <T> void bindInScopeAllowingNulls(Binder binder, Class<T> type) {
        Provider delegate = Providers.of(null);
        ProviderOverLookup<T> lkpProvider = new ProviderOverLookup<T>(type, delegate);
        this.nullableTypes.add(type);
        binder.bind(type).toProvider(lkpProvider);
    }

    protected <T> void bindInScope(Binder binder, Class<T> type) {
        binder.bind(type).toProvider(new ProviderOverLookup<T>(type, new ErrorProvider<T>(type)));
        this.types.add(type);
    }

    public <T> Provider<T> provider(Class<T> type, Provider<T> unscoped) {
        return this.scope(Key.get(type), unscoped);
    }

    public void bindTypes(Binder binder, Class<?> ... types) {
        for (Class<?> type : types) {
            this.bindInScope(binder, type);
        }
    }

    public void bindTypesAllowingNulls(Binder binder, Class<?> ... types) {
        for (Class<?> type : types) {
            this.bindInScopeAllowingNulls(binder, type);
        }
    }

    protected abstract QuietAutoCloseable enter(Object ... var1);

    protected abstract void exit();

    protected abstract <T> T get(Class<T> var1);

    public abstract boolean inScope();

    protected Object[] convertObjects(Object ... originals) {
        return originals;
    }

    public void setIncludeStackTraces(boolean val) {
        this.includeStackTraces = val;
    }

    public boolean contains(Class<?> type) {
        return this.get(type) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        for (Object o : this.contents()) {
            sb.append('\t').append(o.getClass().getName()).append(": ").append(o).append('\n');
        }
        return sb.append("}").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, A> T run(ThrowingFunction<A, T> invokable, A arg, Object ... scopeContents) throws Exception {
        this.enter(scopeContents);
        try {
            Object object = invokable.apply(arg);
            return (T)object;
        }
        finally {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Callable<T> callable, Object ... args) throws Exception {
        this.enter(args);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.exit();
        }
    }

    public void run(Runnable runnable, Object ... args) {
        this.enter(args);
        try {
            runnable.run();
        }
        finally {
            this.exit();
        }
    }

    public void join(final Runnable runnable, ExecutorService executor) {
        if (!this.inScope()) {
            throw new IllegalThreadStateException("Not in scope " + this);
        }
        final Object[] o = this.contents().toArray();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractScope.this.enter(o);
                    runnable.run();
                }
                finally {
                    AbstractScope.this.exit();
                }
            }
        });
    }

    public ExecutorService wrapThreadPool(ExecutorService service) {
        if (service instanceof ScopedThreadPool && ((ScopedThreadPool)service).scope == this) {
            return service;
        }
        return new ScopedThreadPool(this, service);
    }

    public Provider<ExecutorService> wrapThreadPool(final Provider<ExecutorService> exe) {
        return new Provider<ExecutorService>(){
            private ExecutorService val;

            public ExecutorService get() {
                if (this.val != null) {
                    return this.val;
                }
                ExecutorService orig = (ExecutorService)exe.get();
                this.val = new ScopedThreadPool(AbstractScope.this, orig);
                return this.val;
            }
        };
    }

    public Runnable wrap(Runnable runnable) {
        if (runnable instanceof WrapRunnable && ((WrapRunnable)runnable).scope == this) {
            return runnable;
        }
        if (!this.inScope()) {
            throw new IllegalThreadStateException("Not in scope " + this);
        }
        return new WrapRunnable(runnable, this);
    }

    public <T, R> ThrowingFunction<T, R> wrap(ThrowingFunction<T, R> i, AtomicReference<T> arg) {
        if (i instanceof WrapInvokable && ((WrapInvokable)i).scope == this) {
            return i;
        }
        return new WrapInvokable<T, R>(this, i, arg);
    }

    public <T> Callable<T> wrap(Callable<T> wrapped) {
        return new WrapCallable<T>(wrapped);
    }

    public <T> Callable<T> wrap(Callable<T> callable, Object ... contents) {
        return new WrapCallable<T>(callable, contents);
    }

    protected abstract List<Object> contents();

    private static String types(Set<Class<?>> types) {
        ArrayList l = new ArrayList(types);
        Collections.sort(l, (o1, o2) -> o1.getSimpleName().compareTo(o2.getSimpleName()));
        StringBuilder sb = new StringBuilder();
        for (Class clazz : l) {
            sb.append("\n").append(clazz.getSimpleName()).append("\t").append(clazz.getPackage());
        }
        return sb.toString();
    }

    private static String scopeContents(Collection<?> c) {
        StringBuilder sb = new StringBuilder();
        for (Object o : c) {
            if (o == null) {
                sb.append("\n  null\t(NULL?!!!)");
                continue;
            }
            sb.append("\n ").append(o).append("\t").append(o.getClass().getSimpleName());
        }
        sb.append("\n");
        return sb.toString();
    }

    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return new ProviderOverLookup<T>(key.getTypeLiteral().getRawType(), unscoped);
    }

    private final class ProviderOverLookup<T>
    implements Provider<T> {
        private final Provider<T> delegate;
        private final Class<T> type;

        ProviderOverLookup(Class<T> type, Provider<T> delegate) {
            this.type = type;
            this.delegate = delegate;
        }

        public T get() {
            T result = AbstractScope.this.get(this.type);
            if (result == null) {
                result = this.delegate == null ? null : this.delegate.get();
            }
            return result;
        }
    }

    private final class ErrorProvider<T>
    implements Provider<T> {
        private final Class<T> type;

        ErrorProvider(Class<T> type) {
            this.type = type;
        }

        public T get() {
            String typeName = this.type.getSimpleName();
            TypeVariable<Class<T>>[] tps = this.type.getTypeParameters();
            if (tps != null && tps.length > 0) {
                StringBuilder sb = new StringBuilder(typeName).append("<");
                for (TypeVariable<Class<T>> c : tps) {
                    sb.append(c);
                }
                typeName = sb.append('>').toString();
            }
            String info = (String)AbstractScope.this.injectionInfoProvider.get();
            if (AbstractScope.this.inScope()) {
                List<Object> contents = AbstractScope.this.contents();
                String message = info + " in " + AbstractScope.this.getClass().getSimpleName() + " but no instance of " + typeName + " available.  Scope contents: " + AbstractScope.scopeContents(contents) + " Bound in scope: " + AbstractScope.types(AbstractScope.this.types) + " " + AbstractScope.this.nullableTypes;
                IllegalStateException ise = new IllegalStateException(new AlignedText(message).toString());
                if (AbstractScope.this.includeStackTraces) {
                    // empty if block
                }
                throw ise;
            }
            throw new IllegalStateException(info + " not in this scope, and no instance of " + typeName + " available outside " + AbstractScope.this.getClass().getSimpleName() + " scope");
        }
    }

    static class WrapInvokable<T, R>
    implements ThrowingFunction<T, R> {
        private final AbstractScope scope;
        private final ThrowingFunction<T, R> invokable;
        private final Object[] scopeContents;
        private final AtomicReference<T> arg;

        WrapInvokable(AbstractScope scope, ThrowingFunction<T, R> callable, AtomicReference<T> arg) {
            this.scope = scope;
            this.invokable = callable;
            this.scopeContents = scope.contents().toArray();
            this.arg = arg;
        }

        ThrowingFunction<T, R> unwrap() {
            return this.invokable;
        }

        public String toString() {
            return this.invokable.toString();
        }

        public R apply(T argument) throws Exception {
            this.scope.enter(this.scopeContents);
            try {
                Object object = this.invokable.apply(this.arg.get());
                return (R)object;
            }
            finally {
                this.scope.exit();
            }
        }
    }

    static class WrapRunnable
    implements Runnable {
        private final Runnable run;
        private final AbstractScope scope;
        private final Object[] scopeContents;
        private final RuntimeException t = new RuntimeException();

        WrapRunnable(Runnable run, AbstractScope scope) {
            this.run = run;
            this.scope = scope;
            this.scopeContents = scope.contents().toArray();
        }

        @Override
        public void run() {
            this.scope.enter(this.scopeContents);
            try {
                this.run.run();
            }
            catch (RuntimeException e) {
                this.t.initCause(e);
                throw this.t;
            }
            finally {
                this.scope.exit();
            }
        }

        public Runnable unwrap() {
            return this.run;
        }

        public String toString() {
            return "Wrapper{" + this.run + "} with " + Arrays.asList(this.scopeContents);
        }
    }

    private class WrapCallable<T>
    implements Callable<T> {
        private final Callable<T> wrapped;
        private final Object[] contents;

        public WrapCallable(Callable<T> wrapped, Object ... contents) {
            this.wrapped = wrapped;
            List<Object> l = AbstractScope.this.contents();
            l.addAll(Arrays.asList(contents));
            this.contents = l.toArray();
        }

        public WrapCallable(Callable<T> wrapped) {
            this.wrapped = wrapped;
            this.contents = AbstractScope.this.contents().toArray(new Object[0]);
        }

        @Override
        public T call() throws Exception {
            try (QuietAutoCloseable qac = AbstractScope.this.enter(this.contents);){
                T t = this.wrapped.call();
                return t;
            }
        }
    }
}

