/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.scope;

import com.mastfrog.giulius.scope.AbstractScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ScopedThreadPool
implements ExecutorService {
    final AbstractScope scope;
    private final ExecutorService executor;

    ScopedThreadPool(AbstractScope scope, ExecutorService executor) {
        this.scope = scope;
        this.executor = executor;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> found = this.executor.shutdownNow();
        ArrayList<Runnable> result = new ArrayList<Runnable>(found.size());
        for (Runnable r : found) {
            if (r instanceof AbstractScope.WrapRunnable) {
                r = ((AbstractScope.WrapRunnable)r).unwrap();
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.scope.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(this.scope.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        Runnable wrapped = this.scope.wrap(task);
        return this.executor.submit(wrapped);
    }

    <T> List<Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> c : tasks) {
            callables.add(this.scope.wrap(c));
        }
        return callables;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(this.wrap(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }
}

