/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.scope;

import com.google.inject.Scope;
import com.mastfrog.giulius.scope.AbstractScope;
import com.mastfrog.util.thread.QuietAutoCloseable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class SingleEntryScope
extends AbstractScope
implements Scope {
    private final ThreadLocal<Object[]> values = new ThreadLocal();

    @Override
    protected List<Object> contents() {
        Object[] result = this.values.get();
        return result == null ? Collections.emptyList() : Arrays.asList(result);
    }

    @Override
    public void run(Runnable toRun, Object ... scopeContents) {
        this.enter(scopeContents);
        try {
            toRun.run();
        }
        finally {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> toCall, Object ... scopeContents) throws Exception {
        this.enter(scopeContents);
        try {
            T t = toCall.call();
            return t;
        }
        finally {
            this.exit();
        }
    }

    @Override
    protected QuietAutoCloseable enter(Object ... scopeContents) {
        if (this.values.get() != null) {
            throw new IllegalStateException("Already in scope " + this);
        }
        this.values.set(scopeContents);
        return new QuietAutoCloseable(){

            public void close() {
                SingleEntryScope.this.exit();
            }
        };
    }

    @Override
    protected <T> T get(Class<T> type) {
        Object[] contents = this.values.get();
        for (int i = contents.length - 1; i >= 0; --i) {
            if (!type.isInstance(contents[i])) continue;
            return type.cast(contents[i]);
        }
        return null;
    }

    @Override
    public boolean inScope() {
        return this.values.get() != null;
    }

    @Override
    protected void exit() {
        if (this.values.get() == null) {
            throw new IllegalStateException("Not in scope " + this);
        }
        this.values.remove();
    }
}

