/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Label;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.builder.AbstractBuilder;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validating;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.localization.LocalizationSupport;

public final class Host
implements URLComponent,
Validating,
Iterable<Label> {
    static final Pattern IPV6_REGEX = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");
    private static final long serialVersionUID = 1L;
    final boolean ipv6;
    private final Label[] labels;

    public Host(boolean ipv6, Label ... labels) {
        Checks.notNull((String)"domains", (Object)labels);
        Checks.noNullElements((String)"domains", (Object[])labels);
        this.ipv6 = ipv6;
        this.labels = new Label[labels.length];
        System.arraycopy(labels, 0, this.labels, 0, labels.length);
    }

    public Host(Label ... labels) {
        this(false, labels);
    }

    public int size() {
        return this.labels.length;
    }

    public Label getElement(int ix) {
        return this.labels[ix];
    }

    public boolean isDomain(String domain) {
        Checks.notNull((String)"domain", (Object)domain);
        Host host = Host.parse(domain);
        boolean result = true;
        int labelCount = host.size() - 1;
        int mySize = this.size() - 1;
        if (labelCount < 0 || mySize < 0) {
            return false;
        }
        while ((result &= host.getElement(labelCount).equals(this.getElement(mySize))) && --labelCount >= 0 && --mySize >= 0) {
        }
        return result;
    }

    public static Host parse(String path) {
        if (IPV6_REGEX.matcher(path).matches() || path.startsWith("::")) {
            String[] parts = path.split(":");
            Label[] labels = new Label[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                labels[i] = new Label(parts[i]);
            }
            return new Host(true, labels);
        }
        String[] parts = path.split("\\.");
        Label[] els = new Label[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            els[i] = new Label(parts[i]);
        }
        return new Host(els);
    }

    public Label getTopLevelDomain() {
        if (this.isIpAddress()) {
            return null;
        }
        return this.labels.length > 1 ? this.labels[this.labels.length - 1] : null;
    }

    public Label getDomain() {
        if (this.isIpAddress()) {
            return null;
        }
        return this.labels.length > 1 ? this.labels[this.labels.length - 2] : null;
    }

    public Label[] getLabels() {
        Label[] result = new Label[this.labels.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.labels[this.labels.length - (1 + i)];
        }
        return result;
    }

    public Host getParentDomain() {
        if (this.labels.length > 1) {
            Label[] l = new Label[this.labels.length - 1];
            System.arraycopy(this.labels, 1, l, 0, l.length);
            return new Host(l);
        }
        return null;
    }

    public boolean isIpAddress() {
        boolean result;
        boolean bl = result = this.labels.length > 0;
        if (result) {
            boolean ipv6Found = false;
            for (Label label : this.labels) {
                boolean isIpv6 = label.isValidIpV6Component();
                boolean isIpv4 = label.isValidIpV4Component();
                ipv6Found |= isIpv6;
                boolean bl2 = result = isIpv4 || isIpv6;
                if (!result) break;
            }
            if (result && ipv6Found && this.labels.length > 8) {
                return false;
            }
            if (!this.ipv6 && result && this.labels.length != 4) {
                return false;
            }
        }
        return result;
    }

    public boolean isIpV4Address() {
        boolean result;
        boolean bl = result = this.labels.length == 4;
        if (result) {
            Label label;
            Label[] labelArray = this.labels;
            int n = labelArray.length;
            for (int i = 0; i < n && (result = (label = labelArray[i]).isValidIpV4Component()); ++i) {
            }
        }
        return result;
    }

    public boolean isIpV6Address() {
        boolean result;
        boolean bl = result = this.ipv6 && this.labels.length > 0 && this.labels.length <= 8;
        if (result) {
            for (Label label : this.labels) {
                if (!(result &= label.isValidIpV6Component())) break;
            }
        }
        return result;
    }

    public int length() {
        int len = 0;
        for (Label dom : this.labels) {
            boolean hadContents;
            boolean bl = hadContents = len > 0;
            if (hadContents) {
                ++len;
            }
            len += dom.length();
        }
        return len;
    }

    @Override
    public boolean isValid() {
        boolean result;
        if (this.isLocalhost() && !"".equals(this.toString())) {
            return true;
        }
        if (this.isIpV6Address()) {
            return true;
        }
        boolean ip = this.isIpAddress();
        boolean bl = result = ip || this.isLocalHostname() || this.isInternetHostname();
        if (result) {
            boolean someNumeric = false;
            boolean allNumeric = true;
            for (Label d : this.labels) {
                result &= d.isValid();
                boolean num = d.isNumeric();
                allNumeric &= num;
                someNumeric |= num;
            }
            if (someNumeric && !allNumeric) {
                return false;
            }
        }
        if (result) {
            int length = this.length();
            boolean bl2 = result = length <= 255 && length > 0;
        }
        if (result && ip) {
            int sz = this.size();
            boolean bl3 = result = sz == 4 || sz == 6;
        }
        if (result) {
            Problems p = this.getProblems();
            result = p == null ? result : !p.hasFatal();
        }
        return result;
    }

    private boolean isDomain() {
        return this.getDomain() != null;
    }

    private boolean isLocalHostname() {
        return this.labels.length == 1 && !this.isDomain() && !this.isTopLevelDomain();
    }

    private boolean isInternetHostname() {
        return this.isDomain() && this.isTopLevelDomain();
    }

    private boolean isTopLevelDomain() {
        return this.getTopLevelDomain() != null;
    }

    public Problems getProblems() {
        if (this.isLocalhost() && !"".equals(this.toString())) {
            return null;
        }
        String s = this.toString();
        Problems problems = new Problems();
        StringValidators validator = this.isIpV4Address() ? StringValidators.IP_ADDRESS : StringValidators.HOST_NAME;
        validator.validate(problems, this.getComponentName(), (Object)s);
        if (this.isIpV6Address()) {
            return problems;
        }
        if (problems.allProblems().isEmpty()) {
            if (!this.isIpAddress() && !this.isLocalHostname() && this.getTopLevelDomain() == null) {
                problems.append(LocalizationSupport.getMessage(Host.class, (String)"TopLevelDomainMissing", (Object[])new Object[0]));
            }
            if (!this.isIpAddress() && !this.isLocalHostname() && this.getDomain() == null) {
                problems.append(LocalizationSupport.getMessage(Host.class, (String)"DomainMissing", (Object[])new Object[0]));
            }
            if (this.length() > 255) {
                problems.append(LocalizationSupport.getMessage(Host.class, (String)"HostTooLong", (Object[])new Object[0]));
            }
            if (this.isIpV4Address() && this.size() != 4) {
                problems.append(LocalizationSupport.getMessage(Host.class, (String)"WrongNumberOfElementsForIpAddress", (Object[])new Object[0]));
            }
            boolean someNumeric = false;
            boolean allNumeric = true;
            for (Label d : this.labels) {
                boolean num = d.isNumeric();
                allNumeric &= num;
                someNumeric |= num;
            }
            if (someNumeric && !allNumeric) {
                problems.append(LocalizationSupport.getMessage(Host.class, (String)"HostMixesNumericAndNonNumeric", (Object[])new Object[0]));
            }
        }
        return problems.hasFatal() ? problems : null;
    }

    public static AbstractBuilder<Label, Host> builder() {
        return new HostBuilder();
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(Host.class, (String)"host", (Object[])new Object[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean leadingEmpty = false;
        for (int i = 0; i < this.labels.length; ++i) {
            Label label = this.labels[i];
            if (this.ipv6 && i == 0 && label.isEmpty()) {
                leadingEmpty = true;
            }
            if (sb.length() > 0) {
                sb.append(this.ipv6 ? (char)':' : '.');
            }
            label.appendTo(sb);
        }
        if (this.ipv6 && leadingEmpty) {
            sb.insert(0, "::");
        }
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Host other = (Host)obj;
        if (this.isLocalhost() && other.isLocalhost()) {
            return true;
        }
        if (this.ipv6 || this.isIpV4Address() && other.isIpV4Address() || this.isIpV6Address() && other.isIpV6Address()) {
            return Arrays.equals(this.toIntArray(), other.toIntArray());
        }
        return Arrays.equals(this.labels, other.labels);
    }

    private String arr2s() {
        StringBuilder sb = new StringBuilder();
        for (int i : this.toIntArray()) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(Integer.toHexString(i));
        }
        return sb.toString();
    }

    private boolean isLocalhostIpV6() {
        boolean result;
        if (!this.isIpV6Address()) {
            return false;
        }
        boolean bl = result = this.labels.length <= 8;
        if (result) {
            for (int i = 0; i < this.labels.length; ++i) {
                int intValue = this.labels[i].asInt(true);
                result = i == this.labels.length - 1 ? (result &= intValue == 1) : (result &= intValue == 0);
                if (!result) break;
            }
        }
        return result;
    }

    boolean isIpv6() {
        return this.ipv6;
    }

    public boolean isLocalhost() {
        if (this.labels.length == 1 && this.labels[0].toString().isEmpty()) {
            return true;
        }
        if (this.labels.length == 1 && "localhost".equals(this.labels[0].toString())) {
            return true;
        }
        String stringValue = this.toString();
        return "127.0.0.1".equals(stringValue) || "::1".equals(stringValue) || this.isLocalhostIpV6();
    }

    public int hashCode() {
        if (this.isLocalhost()) {
            return 1;
        }
        if (this.isIpAddress()) {
            return Arrays.hashCode(this.toIntArray());
        }
        int hash = 5;
        hash = 73 * hash + Arrays.deepHashCode(this.labels);
        return hash;
    }

    private int[] findLongestZeroRunStart(int[] ints) {
        int length = 0;
        int start = -1;
        int currStart = -1;
        boolean inRun = false;
        for (int i = 0; i < ints.length; ++i) {
            boolean endOfRun;
            boolean isZero;
            boolean bl = isZero = ints[i] == 0;
            if (!inRun && isZero) {
                currStart = i;
                inRun = true;
                continue;
            }
            boolean bl2 = endOfRun = inRun && !isZero;
            if (!endOfRun) continue;
            inRun = false;
            if (i - currStart <= length) continue;
            length = i - currStart;
            start = currStart;
        }
        if (length == 1 || length == 0) {
            return new int[]{-1, 0};
        }
        return new int[]{start, start + length};
    }

    public Host canonicalize() {
        if (this.isLocalhost()) {
            if (this.labels.length == 0 || this.labels.length == 1 && this.labels[0].getLabel().equals("")) {
                return this;
            }
            return this.ipv6 ? new Host(true, new Label(""), new Label(""), new Label("1")) : new Host(this.ipv6, new Label("127"), new Label("0"), new Label("0"), new Label("1"));
        }
        if (this.isIpV6Address()) {
            ArrayList<Label> result = new ArrayList<Label>(8);
            int[] ints = this.toIntArray();
            int[] skip = this.findLongestZeroRunStart(ints);
            boolean allZeros = true;
            for (int i = 0; i < ints.length; ++i) {
                allZeros &= ints[i] == 0;
                if (i == skip[0]) {
                    result.add(new Label(""));
                }
                if (skip[0] != -1 && i >= skip[0] && i < skip[1]) continue;
                result.add(new Label(Integer.toHexString(ints[i])));
            }
            if (allZeros) {
                return new Host(true, new Label(""), new Label(""));
            }
            return new Host(true, result.toArray(new Label[result.size()]));
        }
        return this;
    }

    @Override
    public Iterator<Label> iterator() {
        return CollectionUtils.toIterator((Object[])this.labels);
    }

    public int[] toIntArray() {
        Label label;
        int[] result = new int[this.ipv6 ? 8 : 4];
        Iterator forward = CollectionUtils.toIterator((Object[])this.labels);
        int remaining = this.labels.length;
        int ix = 0;
        while (forward.hasNext() && !(label = (Label)forward.next()).isEmpty()) {
            result[ix++] = label.asInt(this.ipv6);
            --remaining;
        }
        ix = result.length - 1;
        if (remaining > 0) {
            Iterator backward = CollectionUtils.toReverseIterator((Object[])this.labels);
            while (remaining > 0 && ix > 0) {
                result[ix--] = ((Label)backward.next()).asInt(this.ipv6);
                --remaining;
            }
        }
        return result;
    }

    private static final class HostBuilder
    extends AbstractBuilder<Label, Host> {
        private HostBuilder() {
        }

        @Override
        public Host create() {
            return this.create(false);
        }

        public Host create(boolean ipv6) {
            Label[] domains = this.elements().toArray(new Label[this.size()]);
            Label[] reversed = new Label[domains.length];
            for (int i = 0; i < domains.length; ++i) {
                reversed[i] = domains[domains.length - (i + 1)];
            }
            return new Host(reversed);
        }

        @Override
        protected Label createElement(String string) {
            return new Label(string);
        }
    }
}

