/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Host;
import com.mastfrog.url.Port;
import com.mastfrog.util.preconditions.Checks;

public class HostAndPort {
    public final Host host;
    public final Port port;

    public HostAndPort(Host host, Port port) {
        Checks.notNull((String)"host", (Object)host);
        Checks.notNull((String)"port", (Object)port);
        this.host = host;
        this.port = port;
    }

    public boolean isValid() {
        return this.host.isValid() && this.port.isValid();
    }

    public String toString() {
        return this.host.toString() + ":" + this.port.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof HostAndPort) {
            HostAndPort other = (HostAndPort)o;
            return this.port.equals(other.port) && this.host.equals(other.host);
        }
        return false;
    }

    public int hashCode() {
        return this.port.hashCode() + 53 * this.host.hashCode();
    }

    public String host() {
        return this.host.toString();
    }

    public int port() {
        return this.port.intValue();
    }
}

