/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.URLBuilder;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import org.netbeans.validation.localization.LocalizationSupport;

public final class ParametersElement
implements URLComponent,
Comparable<ParametersElement> {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String key;
    public static final ParametersElement EMPTY = new ParametersElement();

    public ParametersElement(String key, String value) {
        this.key = key;
        this.value = value;
        if (key == null && value == null) {
            Checks.notNull((String)"key and value", (Object)key);
        }
    }

    private ParametersElement() {
        this.key = null;
        this.value = null;
    }

    public static ParametersElement parse(String queryString) {
        Checks.notNull((String)"qeString", (Object)queryString);
        int ix = queryString.indexOf(61);
        if (ix == 0 && queryString.length() > 1) {
            return new ParametersElement(null, queryString);
        }
        if (ix < 0) {
            return new ParametersElement(queryString, null);
        }
        if (queryString.length() > 0) {
            String key = queryString.substring(0, ix);
            String val = queryString.substring(ix + 1);
            return new ParametersElement(key, val);
        }
        return new ParametersElement(queryString, null);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String decodedKey() {
        return Strings.urlDecode((String)this.key);
    }

    public String decodedValue() {
        return Strings.urlDecode((String)this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        boolean result;
        boolean bl = result = this.key != null;
        if (result) {
            result &= URLBuilder.isoEncoder().canEncode(this.key);
        }
        if (this.value != null) {
            result &= URLBuilder.isoEncoder().canEncode(this.value);
        }
        return result;
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(ParametersElement.class, (String)"parameters_element", (Object[])new Object[0]);
    }

    @Override
    public void appendTo(StringBuilder sb) {
        if (this.key != null) {
            URLBuilder.append(sb, this.key, '/', '+', ':', '?', '=');
        }
        if (this.value != null) {
            sb.append('=');
        }
        if (this.value != null) {
            URLBuilder.append(sb, this.value, '/', '+', ':', '?', '=');
        }
    }

    @Override
    public int compareTo(ParametersElement o) {
        return o.key.compareToIgnoreCase(this.key);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParametersElement other = (ParametersElement)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 59 * hash + (this.key != null ? this.key.hashCode() : 0);
        return hash;
    }
}

