/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.URLBuilder;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.preconditions.Checks;
import org.netbeans.validation.localization.LocalizationSupport;

public final class PathElement
implements URLComponent {
    private static final long serialVersionUID = 1L;
    private final String element;
    private final boolean trailingSlash;
    private final boolean noEncode;

    public PathElement(String element) {
        this(element, false);
    }

    public PathElement(String element, boolean trailingSlash) {
        this(element, trailingSlash, false);
    }

    public PathElement(String element, boolean trailingSlash, boolean noEncode) {
        Checks.notNull((String)"element", (Object)element);
        this.element = element;
        this.trailingSlash = trailingSlash;
        this.noEncode = noEncode;
    }

    String rawText() {
        return this.element;
    }

    PathElement toTrailingSlashElement() {
        return this.trailingSlash ? this : new PathElement(this.element, true, this.noEncode);
    }

    PathElement toNonTrailingSlashElement() {
        return this.trailingSlash ? new PathElement(this.element, false) : this;
    }

    @Override
    public boolean isValid() {
        return this.element.indexOf(47) < 0 && URLBuilder.isEncodableInLatin1(this.element);
    }

    public String toString() {
        return this.noEncode ? this.element : URLBuilder.escape(this.element, '/', '+', ':', '?', '=', '_');
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(PathElement.class, (String)"path_element", (Object[])new Object[0]);
    }

    @Override
    public void appendTo(StringBuilder sb) {
        this.appendTo(sb, false);
    }

    public void appendTo(StringBuilder sb, boolean includeTrailingSlashIfPresent) {
        if (this.noEncode) {
            sb.append(this.element);
        } else {
            URLBuilder.append(sb, this.element, '/', '+', ':', '?', '=', '-');
        }
        if (this.trailingSlash && includeTrailingSlashIfPresent) {
            sb.append('/');
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.element != null ? this.element.hashCode() : 0);
        return hash;
    }

    public boolean isProbableFileReference() {
        return !this.trailingSlash && !"..".equals(this.element) && !".".equals(this.element) && this.element.indexOf(46) > 0;
    }

    public String extension() {
        int ix = this.element.lastIndexOf(46);
        if (ix < 0 || ix == this.element.length() - 1) {
            return null;
        }
        return this.element.substring(ix + 1);
    }

    public boolean extensionEquals(String ext) {
        int last = this.element.length() - 1;
        if (this.element.isEmpty() || this.element.charAt(last) == '/') {
            return false;
        }
        if (ext.length() > last + 2) {
            return false;
        }
        int pos = last;
        for (int i = 0; i < ext.length(); ++i) {
            char got;
            int extLoc = ext.length() - 1 - i;
            char test = ext.charAt(extLoc);
            if (test != (got = this.element.charAt(last - i))) {
                return false;
            }
            --pos;
        }
        return pos != -1 && this.element.charAt(pos) == '.';
    }
}

