/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Anchor;
import com.mastfrog.url.GenericUrlComponent;
import com.mastfrog.url.Host;
import com.mastfrog.url.HostAndPort;
import com.mastfrog.url.Parameters;
import com.mastfrog.url.ParametersElement;
import com.mastfrog.url.ParsedParameters;
import com.mastfrog.url.Path;
import com.mastfrog.url.Port;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.Protocols;
import com.mastfrog.url.URLBuilder;
import com.mastfrog.url.URLComponent;
import com.mastfrog.url.URLParser;
import com.mastfrog.util.builder.AbstractBuilder;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.NullArgumentException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validating;
import org.netbeans.validation.localization.LocalizationSupport;

public final class URL
implements URLComponent,
Validating,
Comparable<URL> {
    private static final long serialVersionUID = 1L;
    private final Anchor anchor;
    private final Protocol protocol;
    private final Host host;
    private final Port port;
    private final Path path;
    private final Parameters parameters;
    private final String password;
    private final String userName;

    URL(String userName, String password, Protocol protocol, Host host, Port port, Path path, Parameters query, Anchor anchor) {
        this.userName = userName;
        this.password = password;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = query;
        this.anchor = anchor;
    }

    public URL withProtocol(Protocol protocol) {
        if (protocol.equals(this.protocol)) {
            return this;
        }
        return new URL(this.userName, this.password, protocol, this.host, this.port, this.path, this.parameters, this.anchor);
    }

    public static URLBuilder builder() {
        return new URLBuilder();
    }

    public static URLBuilder builder(Protocol protocol) {
        Checks.notNull((String)"protocol", (Object)protocol);
        return new URLBuilder(protocol);
    }

    public static URLBuilder builder(URL startWith) {
        Checks.notNull((String)"startWith", (Object)startWith);
        return new URLBuilder(startWith);
    }

    public static URL parse(String url) {
        Checks.notNull((String)"url", (Object)url);
        return new URLParser(url).getURL();
    }

    public URL getBaseURL(boolean retainPort) {
        return new URL(null, null, this.protocol, this.host, retainPort ? this.port : null, this.path, null, null);
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public Host getHost() {
        return this.host;
    }

    public Path getPath() {
        return this.path;
    }

    public Port getPort() {
        return this.port == null ? (this.protocol == null ? null : this.protocol.getDefaultPort()) : this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public URLComponent getUserName() {
        return this.userName == null ? null : new GenericUrlComponent(LocalizationSupport.getMessage(URL.class, (String)"user_name", (Object[])new Object[0]), this.userName, true);
    }

    public URLComponent getPassword() {
        return this.password == null ? null : new GenericUrlComponent(LocalizationSupport.getMessage(URL.class, (String)"password", (Object[])new Object[0]), this.password, true);
    }

    public boolean isKnownProtocol() {
        return this.protocol == null ? false : this.protocol.isKnownProtocol();
    }

    public boolean isProbableFileReference() {
        return this.path == null ? false : this.path.isProbableFileReference();
    }

    public boolean isSameDomain(String domain) {
        return this.host == null ? false : this.host.isDomain(domain);
    }

    public HostAndPort getHostAndPort() {
        return new HostAndPort(this.getHost(), this.getPort());
    }

    @Override
    public void appendTo(StringBuilder sb) {
        Checks.notNull((String)"sb", (Object)sb);
        URL.appendIfNotNull(sb, this.protocol);
        if (this.protocol != null) {
            sb.append("://");
        }
        if (this.userName != null) {
            this.getUserName().appendTo(sb);
        }
        if (this.userName != null || this.password != null) {
            sb.append(':');
        }
        if (this.password != null) {
            this.getPassword().appendTo(sb);
        }
        if (this.userName != null || this.password != null) {
            sb.append('@');
        }
        if (this.host != null && this.host.length() == 0 && this.host.isLocalhost() && !Protocols.FILE.match(this.protocol)) {
            sb.append("127.0.0.1");
        } else if (this.host != null) {
            Host hst = this.host.canonicalize();
            if (hst.isIpv6() && this.port != null && this.protocol != null && !this.port.equals(this.protocol.getDefaultPort())) {
                sb.append('[').append(hst).append(']');
            } else {
                sb.append(hst);
            }
        }
        if (this.port != null) {
            int defVal;
            int val = this.port.intValue();
            if (this.protocol != null && this.protocol.getDefaultPort() != null && (defVal = this.protocol.getDefaultPort().intValue()) != val) {
                sb.append(':');
                this.port.appendTo(sb);
            }
        }
        sb.append("/");
        URL.appendIfNotNull(sb, this.path);
        if (this.parameters != null) {
            this.parameters.appendTo(sb);
        }
        if (this.anchor != null) {
            this.anchor.appendTo(sb);
        }
    }

    public String getPathAndQuery() {
        StringBuilder sb = new StringBuilder();
        if (this.path != null) {
            sb.append('/');
            this.path.appendTo(sb);
        }
        if (this.anchor != null) {
            this.anchor.appendTo(sb);
        }
        if (this.parameters != null) {
            this.parameters.appendTo(sb);
        }
        return sb.toString();
    }

    public boolean isSecure() {
        return this.protocol != null && this.protocol.isSecure();
    }

    public URLComponent[] components() {
        ArrayList comps = new ArrayList(6);
        URL.addIfNotNull(comps, this.protocol);
        URL.addIfNotNull(comps, this.getUserName());
        URL.addIfNotNull(comps, this.getPassword());
        URL.addIfNotNull(comps, this.host);
        URL.addIfNotNull(comps, this.port);
        URL.addIfNotNull(comps, this.path);
        URL.addIfNotNull(comps, this.parameters);
        URL.addIfNotNull(comps, this.anchor);
        return comps.toArray(new URLComponent[comps.size()]);
    }

    public URLComponent[] allComponents() {
        ArrayList comps = new ArrayList(6);
        URL.addIfNotNull(comps, this.protocol == null ? Protocol.INVALID : this.protocol);
        if (this.host != null) {
            for (URLComponent uRLComponent : this.host.getLabels()) {
                URL.addIfNotNull(comps, uRLComponent);
            }
        }
        URL.addIfNotNull(comps, this.port);
        if (this.path != null) {
            for (URLComponent uRLComponent : this.path.getElements()) {
                URL.addIfNotNull(comps, uRLComponent);
            }
        }
        if (this.parameters != null) {
            if (this.parameters instanceof ParsedParameters) {
                for (URLComponent uRLComponent : ((ParsedParameters)this.parameters).getElements()) {
                    URL.addIfNotNull(comps, uRLComponent);
                }
            } else {
                URL.addIfNotNull(comps, this.parameters);
            }
        }
        return comps.toArray(new URLComponent[comps.size()]);
    }

    public URLComponent getInvalidComponent() {
        for (URLComponent c : this.allComponents()) {
            if (c.isValid()) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        boolean result;
        URLComponent[] comps = this.components();
        boolean bl = result = comps.length > 0 && this.protocol != null && (!this.protocol.isNetworkProtocol() || this.host != null);
        if (result) {
            for (URLComponent c : comps) {
                Host h;
                if (!(c instanceof Host && (h = (Host)c) != null && Protocols.FILE.match(this.getProtocol()) && "".equals(h.toString()) || (result = c.isValid()))) break;
            }
        }
        return result;
    }

    private static <T> void addIfNotNull(List<T> list, T obj) {
        if (obj != null) {
            list.add(obj);
        }
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(URL.class, (String)"url", (Object[])new Object[0]);
    }

    private boolean isHostOnlyURL() {
        if (this.protocol != null && this.host != null) {
            boolean hasPath;
            boolean hasAnchor = this.anchor != null;
            boolean hasParameters = this.parameters != null && this.parameters.toString().length() > 0;
            boolean bl = hasPath = this.path != null && this.path.size() > 0;
            if (!(hasPath || hasAnchor || hasParameters)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        if (sb.length() > 0 && this.isHostOnlyURL() && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    public String toUnescapedForm() {
        return URLBuilder.unescape(this.toString());
    }

    public URL stripAnchor() {
        return new URL(this.userName, this.password, this.protocol, this.host, this.port, this.path, this.parameters, null);
    }

    public URL stripQuery() {
        return new URL(this.userName, this.password, this.protocol, this.host, this.port, this.path, null, this.anchor);
    }

    public URL toSimpleURL() {
        return new URL(null, null, this.protocol, this.host, this.port, this.path, null, null);
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    public URL withParameter(String name, String value) {
        AbstractBuilder<ParametersElement, Parameters> b = ParsedParameters.builder();
        LinkedList els = new LinkedList();
        if (this.parameters != null) {
            for (URLComponent comp : this.parameters.getElements()) {
                if (comp instanceof ParametersElement) {
                    b.add((Object)((ParametersElement)comp));
                    continue;
                }
                b.add(comp.toString());
            }
        }
        b.add((Object)new ParametersElement(name, value));
        URL url = new URL(null, null, this.protocol, this.host, this.port, this.path, (Parameters)b.create(), null);
        return url;
    }

    public boolean simpleEquals(URL other) {
        if (other == this) {
            return true;
        }
        return other != null && other.toSimpleURL().equals(this.toSimpleURL());
    }

    public URL getParentURL() {
        Path p = this.getPath();
        Path path = p = p == null ? null : p.getParentPath();
        if (p != null) {
            return new URL(this.userName, this.password, this.protocol, this.host, this.port, p, null, null);
        }
        return new URL(this.userName, this.password, this.protocol, this.host, this.port, null, null, null);
    }

    public static URL fromFile(File file) {
        Checks.notNull((String)"file", (Object)file);
        try {
            return URL.fromJavaUrl(file.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            String path = file.getAbsolutePath();
            path = path.replace(File.separatorChar, '/');
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            Protocols p = Protocols.FILE;
            Path pth = Path.parse(path);
            return new URL(null, null, p, null, null, pth, null, null);
        }
    }

    public static URL fromJavaUrl(java.net.URL url) {
        Checks.notNull((String)"url", (Object)url);
        return URL.parse(url.toString());
    }

    private static void appendIfNotNull(StringBuilder sb, URLComponent c) {
        Checks.notNull((String)"sb", (Object)sb);
        if (c != null) {
            c.appendTo(sb);
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URL)) {
            return false;
        }
        if (this.toString().equals(obj.toString())) {
            return true;
        }
        URL other = (URL)obj;
        boolean bl = result = Objects.equals(this.protocol, other.protocol) && Objects.equals(this.anchor, other.anchor) && Objects.equals(this.host, other.host) && Objects.equals(this.path, other.path) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.userName, other.userName) && Objects.equals(this.password, other.password);
        if (!result && this.toString().equals(obj.toString())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + (this.anchor != null ? this.anchor.hashCode() : 0);
        hash = 19 * hash + (this.protocol != null ? this.protocol.hashCode() : 0);
        hash = 19 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 19 * hash + (this.port != null ? this.port.hashCode() : 0);
        hash = 19 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 19 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
        hash = 19 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash = 19 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        return hash;
    }

    public static Charset getURLEncoding() {
        return URLBuilder.ISO_LATIN;
    }

    public java.net.URL toJavaURL() throws MalformedURLException {
        return new java.net.URL(this.toString().replaceAll("%5f", "_"));
    }

    public Problems getProblems() {
        if (!this.isValid()) {
            URLComponent comp;
            Port prt;
            Path p;
            Problems problems = new Problems();
            Host h = this.getHost();
            if (h == null || !Protocols.FILE.match(this.getProtocol()) || !"".equals(h.toString())) {
                if (h != null && !h.isValid()) {
                    try {
                        p = h.getProblems();
                        if (p == null) {
                            p = new Problems();
                            p.append("Host '" + h + "' reports itself invalid but lists no problems");
                        }
                        problems.addAll((Problems)p);
                    }
                    catch (NullArgumentException e) {
                        throw new IllegalStateException(h.toString() + " reports itself invalid but returns no problems", e);
                    }
                } else if (h == null) {
                    problems.append("Host not set: " + this.toString());
                }
            }
            if ((p = this.getPath()) != null && !p.isValid()) {
                if (p.isIllegal()) {
                    problems.append(LocalizationSupport.getMessage(URL.class, (String)"RELATIVE_PATH_HAS_TO_MANY_BACKWARD_STEPS", (Object[])new Object[]{p.toString()}));
                } else {
                    problems.append(LocalizationSupport.getMessage(URL.class, (String)"PATH_CONTAINS_ILLEGAL_CHARACTERS", (Object[])new Object[]{p.toString()}));
                }
            }
            if ((prt = this.getPort()) != null && !prt.isValid()) {
                if (prt.isIllegalChars()) {
                    problems.append(LocalizationSupport.getMessage(URL.class, (String)"PORT_IS_NOT_A_NUMBER", (Object[])new Object[]{prt.toString()}));
                } else {
                    problems.append(LocalizationSupport.getMessage(URL.class, (String)"PORT_OUT_OF_RANGE", (Object[])new Object[]{prt.toString()}));
                }
            }
            if (!problems.hasFatal() && (comp = this.getInvalidComponent()) != null) {
                problems.append(LocalizationSupport.getMessage(URL.class, (String)"BAD_URL_COMPONENT", (Object[])new Object[]{comp.getComponentName()}), Severity.FATAL);
            }
            return problems.hasFatal() ? problems : null;
        }
        return null;
    }

    @Override
    public int compareTo(URL o) {
        return this.toString().compareToIgnoreCase(o.toString());
    }
}

