/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Anchor;
import com.mastfrog.url.Host;
import com.mastfrog.url.Label;
import com.mastfrog.url.Parameters;
import com.mastfrog.url.ParametersDelimiter;
import com.mastfrog.url.ParametersElement;
import com.mastfrog.url.ParsedParameters;
import com.mastfrog.url.Path;
import com.mastfrog.url.PathElement;
import com.mastfrog.url.Port;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.Protocols;
import com.mastfrog.url.URL;
import com.mastfrog.util.builder.AbstractBuilder;
import com.mastfrog.util.preconditions.Checks;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class URLBuilder
extends AbstractBuilder<PathElement, URL> {
    static final char ANCHOR_DELIMITER = '#';
    static final char PASSWORD_DELIMITER = ':';
    static final String PATH_ELEMENT_DELIMITER = "/";
    static final char PORT_DELIMITER = ':';
    static final String PROTOCOL_DELIMITER = "://";
    static final char LABEL_DELIMITER = '.';
    static final char UNENCODABLE_CHARACTER = '?';
    static final char URL_ESCAPE_PREFIX = '%';
    static final char QUERY_PREFIX = '?';
    private Protocol protocol;
    private Host host;
    private int port = -1;
    private String userName;
    private String password;
    private Path path;
    private Parameters query;
    private Anchor anchor;
    private List<ParametersElement> queryElements;
    private List<Label> labels;
    static final Charset ISO_LATIN = Charset.forName("ISO-8859-1");
    private ParametersDelimiter delimiter;

    static CharsetEncoder isoEncoder() {
        return ISO_LATIN.newEncoder();
    }

    public URLBuilder(Protocol protocol) {
        this.protocol = protocol;
    }

    public URLBuilder() {
        this(Protocols.HTTP);
    }

    public URLBuilder(URL prototype) {
        Checks.notNull((String)"prototype", (Object)prototype);
        this.protocol = prototype.getProtocol();
        this.host = prototype.getHost();
        this.port = prototype.getPort() == null ? 1 : prototype.getPort().intValue();
        this.userName = prototype.getUserName() == null ? null : prototype.getUserName().toString();
        String string = this.password = prototype.getPassword() == null ? null : prototype.getPassword().toString();
        if (prototype.getParameters() != null) {
            Parameters p = prototype.getParameters();
            if (p instanceof ParsedParameters) {
                for (ParametersElement qe : ((ParsedParameters)p).getElements()) {
                    this.addQueryPair(qe);
                }
            } else {
                this.query = p;
            }
        }
        this.anchor = prototype.getAnchor();
        Path origPath = prototype.getPath();
        if (origPath != null) {
            int sz = origPath.size();
            for (int i = 0; i < sz; ++i) {
                this.addPathElement(origPath.getElement(i));
            }
        }
    }

    public URLBuilder addPathElement(PathElement element) {
        Checks.notNull((String)"element", (Object)element);
        if (this.path != null) {
            throw new IllegalStateException("Path explicitly set");
        }
        this.add(element);
        return this;
    }

    public URLBuilder addPathElement(String element) {
        Checks.notNull((String)"element", (Object)element);
        if (this.path != null) {
            throw new IllegalStateException("Path explicitly set");
        }
        this.add(element);
        return this;
    }

    public URLBuilder addDomain(Label domain) {
        Checks.notNull((String)"domain", (Object)domain);
        if (this.host != null) {
            throw new IllegalStateException("Host explicitly set");
        }
        if (this.labels == null) {
            this.labels = new LinkedList<Label>();
        }
        this.labels.add(domain);
        return this;
    }

    public URLBuilder addDomain(String domain) {
        Checks.notNull((String)"domain", (Object)domain);
        return this.addDomain(new Label(domain));
    }

    public URLBuilder addQueryPairIfNotNullOrEmpty(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.addQueryPair(key, value);
        }
        return this;
    }

    public URLBuilder addQueryPair(String key, String value) {
        Checks.notNull((String)"value", (Object)value);
        Checks.notNull((String)"key", (Object)key);
        if (this.query != null) {
            throw new IllegalStateException("Query explictly set");
        }
        if (this.queryElements == null) {
            this.queryElements = new LinkedList<ParametersElement>();
        }
        this.queryElements.add(new ParametersElement(key, value));
        return this;
    }

    public URLBuilder addQueryPairs(Map<String, Object> pairs, Function<Object, String> toString) {
        pairs.entrySet().forEach(e -> {
            String s = (String)toString.apply(e.getValue());
            if (s != null) {
                this.addQueryPair((String)e.getKey(), s);
            }
        });
        return this;
    }

    public URLBuilder addQueryPairs(Map<String, String> pairs) {
        pairs.entrySet().forEach(e -> {
            String s = (String)e.getValue();
            if (s != null) {
                this.addQueryPair((String)e.getKey(), s);
            }
        });
        return this;
    }

    public URLBuilder addQueryPair(ParametersElement element) {
        Checks.notNull((String)"element", (Object)element);
        if (this.queryElements == null) {
            this.queryElements = new LinkedList<ParametersElement>();
        }
        this.queryElements.add(element);
        return this;
    }

    public URLBuilder setQueryDelimiter(ParametersDelimiter delimiter) {
        Checks.notNull((String)"delimiter", (Object)((Object)delimiter));
        this.delimiter = delimiter;
        return this;
    }

    public URLBuilder setProtocol(String protocol) {
        Checks.notNull((String)"protocol", (Object)protocol);
        Protocol p = Protocols.forName(protocol);
        return this.setProtocol(p);
    }

    public URLBuilder setProtocol(Protocol protocol) {
        Checks.notNull((String)"protocol", (Object)protocol);
        this.protocol = protocol;
        return this;
    }

    public URLBuilder setAnchor(Anchor anchor) {
        Checks.notNull((String)"anchor", (Object)anchor);
        this.anchor = anchor;
        return this;
    }

    public URLBuilder setAnchor(String anchor) {
        Checks.notNull((String)"anchor", (Object)anchor);
        return this.setAnchor(new Anchor(anchor));
    }

    public URLBuilder setHost(Host host) {
        Checks.notNull((String)"host", (Object)host);
        this.host = host;
        return this;
    }

    public URLBuilder setPassword(String password) {
        Checks.notNull((String)"password", (Object)password);
        this.password = password;
        return this;
    }

    public URLBuilder setPath(Path path) {
        Checks.notNull((String)"path", (Object)path);
        this.path = path;
        return this;
    }

    public URLBuilder setPath(String path) {
        Checks.notNull((String)"path", (Object)path);
        String[] els = path.split(PATH_ELEMENT_DELIMITER);
        LinkedList<PathElement> l = new LinkedList<PathElement>();
        for (int i = 0; i < els.length; ++i) {
            String el = els[i];
            if (i == els.length - 1 && path.trim().endsWith(PATH_ELEMENT_DELIMITER)) {
                l.add(new PathElement(el, true));
                continue;
            }
            l.add(new PathElement(el, false));
        }
        return this.setPath(new Path(l.toArray(new PathElement[l.size()])));
    }

    public URLBuilder setPort(int port) {
        Checks.nonNegative((String)"port", (int)port);
        this.port = port;
        return this;
    }

    public URLBuilder setQuery(Parameters query) {
        Checks.notNull((String)"query", (Object)query);
        if (this.queryElements != null && !this.queryElements.isEmpty()) {
            throw new IllegalStateException("Query elements set");
        }
        this.query = query;
        return this;
    }

    public URLBuilder setUserName(String userName) {
        Checks.notNull((String)"userName", (Object)userName);
        this.userName = userName;
        return this;
    }

    public URLBuilder setHost(String host) {
        Checks.notNull((String)"host", (Object)host);
        this.setHost(Host.parse(host));
        return this;
    }

    @Override
    public URLBuilder add(PathElement element) {
        if (element.toString().equals("")) {
            return this;
        }
        return (URLBuilder)super.add(element);
    }

    protected URLBuilder addElement(PathElement element) {
        if (element.toString().equals("")) {
            return this;
        }
        return (URLBuilder)super.addElement(element);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol);
        sb.append(PROTOCOL_DELIMITER);
        if (this.userName != null) {
            URLBuilder.append(sb, this.userName, new char[0]);
        }
        if (this.password != null) {
            sb.append(':');
            URLBuilder.append(sb, this.password, new char[0]);
        }
        sb.append(this.host);
        if (this.port != -1 && (this.protocol == null || this.port != this.protocol.getDefaultPort().intValue())) {
            sb.append(':');
            sb.append(this.port);
        }
        sb.append(PATH_ELEMENT_DELIMITER);
        if (this.path != null) {
            sb.append(this.path);
        }
        if (this.queryElements != null && !this.queryElements.isEmpty()) {
            ParsedParameters q = new ParsedParameters(this.queryElements.toArray(new ParametersElement[this.queryElements.size()]));
            sb.append(this.delimiter == null ? q.toString(this.delimiter) : q);
        }
        if (this.anchor != null) {
            sb.append('#');
            sb.append(this.anchor);
        }
        return sb.toString();
    }

    static String escape(String toEscape, char ... skip) {
        Checks.notNull((String)"toEscape", (Object)toEscape);
        StringBuilder sb = new StringBuilder(toEscape.length() * 2);
        URLBuilder.append(sb, toEscape, new char[0]);
        return sb.toString();
    }

    static void append(StringBuilder sb, String toEscape, char ... skip) {
        Checks.notNull((String)"toEscape", (Object)toEscape);
        Checks.notNull((String)"sb", (Object)sb);
        if (skip.length > 0) {
            Arrays.sort(skip);
        }
        int max = toEscape.length();
        for (int i = 0; i < max; ++i) {
            char c = toEscape.charAt(i);
            if (skip.length > 0 && Arrays.binarySearch(skip, c) >= 0) {
                sb.append(c);
                continue;
            }
            if (!URLBuilder.isoEncoder().canEncode(c)) {
                sb.append('?');
                continue;
            }
            if (URLBuilder.isLetter(c) || URLBuilder.isNumber(c) || c == '.') {
                sb.append(c);
                continue;
            }
            URLBuilder.appendEscaped(c, sb);
        }
    }

    static boolean isEncodableInLatin1(char c) {
        return URLBuilder.isoEncoder().canEncode(c);
    }

    static boolean isEncodableInLatin1(CharSequence seq) {
        return URLBuilder.isoEncoder().canEncode(seq);
    }

    static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean isValidHostCharacter(char c) {
        return URLBuilder.isLetter(c) || URLBuilder.isNumber(c);
    }

    static boolean isReserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    static void appendEscaped(char c, StringBuilder to) {
        Checks.notNull((String)"to", (Object)to);
        if (c == '\u0000') {
            throw new IllegalArgumentException("Will not append the character 0");
        }
        String hex = Integer.toHexString(c);
        to.append('%');
        if (hex.length() == 1) {
            to.append('0');
        }
        to.append(hex);
    }

    static String unescape(String seq) {
        Checks.notNull((String)"seq", (Object)seq);
        if (seq.indexOf(37) < 0) {
            return seq;
        }
        char[] chars = seq.toCharArray();
        StringBuilder sb = new StringBuilder(seq.length());
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '%' && i < chars.length - 2 && URLBuilder.isHexCharacter(chars[i + 1]) && URLBuilder.isHexCharacter(chars[i + 2])) {
                String hex = new String(chars, i + 1, 2);
                int codePoint = Integer.valueOf(hex, 16);
                c = (char)codePoint;
                sb.append(c);
                i += 2;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static boolean isHexCharacter(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    @Override
    public URL create() {
        Host h = this.host == null ? (this.labels == null ? null : new Host(this.labels.toArray(new Label[this.labels.size()]))) : this.host;
        return new URL(this.userName, this.password, this.protocol, h, this.getPort(), this.getPath(), this.getQuery(), this.anchor);
    }

    Port getPort() {
        if (this.port != -1) {
            return new Port(this.port);
        }
        if (this.protocol != null) {
            return this.protocol.getDefaultPort();
        }
        return null;
    }

    Path getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.size() == 0) {
            return null;
        }
        PathElement[] els = this.elements().toArray(new PathElement[this.size()]);
        return new Path(els);
    }

    Parameters getQuery() {
        if (this.query != null) {
            return this.query;
        }
        if (this.queryElements != null && !this.queryElements.isEmpty()) {
            return new ParsedParameters(this.queryElements.toArray(new ParametersElement[this.queryElements.size()]));
        }
        return null;
    }

    @Override
    protected PathElement createElement(String string) {
        Checks.notNull((String)"string", (Object)string);
        while (string.startsWith(PATH_ELEMENT_DELIMITER) && string.length() != 0) {
            string = string.substring(1);
        }
        return new PathElement(string, false);
    }
}

