/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.builder;

import com.mastfrog.util.builder.Builder;
import com.mastfrog.util.preconditions.Checks;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractBuilder<ElementType, CreateType>
implements Builder<ElementType, CreateType, AbstractBuilder<ElementType, CreateType>> {
    protected final List<ElementType> elements = new LinkedList<ElementType>();

    protected AbstractBuilder() {
    }

    @Override
    public AbstractBuilder<ElementType, CreateType> add(ElementType element) {
        Checks.notNull((String)"element", element);
        this.onBeforeAdd(element);
        this.elements.add(element);
        this.onAfterAdd(element);
        return this;
    }

    protected void onAfterAdd(ElementType element) {
    }

    @Override
    public final AbstractBuilder<ElementType, CreateType> add(String string) {
        Checks.notNull((String)"string", (Object)string);
        return this.add((Object)this.createElement(string));
    }

    protected List<ElementType> elements() {
        return new ArrayList<ElementType>(this.elements);
    }

    protected AbstractBuilder<ElementType, CreateType> addElement(ElementType element) {
        Checks.notNull((String)"element", element);
        this.onBeforeAdd(element);
        this.elements.add(element);
        return this;
    }

    protected int size() {
        return this.elements.size();
    }

    protected abstract ElementType createElement(String var1);

    protected void onBeforeAdd(ElementType toAdd) {
    }
}

