/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.builder;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.thread.AutoCloseThreadLocal;
import com.mastfrog.util.thread.QuietAutoCloseable;
import java.util.function.BiFunction;

public final class ThreadLocalBuilderSupport<T> {
    private final AutoCloseThreadLocal<T> local = new AutoCloseThreadLocal();
    private BiFunction<T, T, T> coalescer;

    public ThreadLocalBuilderSupport() {
    }

    public ThreadLocalBuilderSupport(BiFunction<T, T, T> coalescer) {
        this.coalescer = coalescer;
    }

    public T get() {
        return (T)this.local.get();
    }

    public QuietAutoCloseable with(T val) {
        Object curr = this.local.get();
        if (this.coalescer == null) {
            throw new IllegalStateException("Already set to " + curr);
        }
        T nue = curr == null ? val : this.coalescer.apply(curr, val);
        QuietAutoCloseable outer = this.local.set(nue);
        return () -> {
            outer.close();
            this.local.set(curr);
        };
    }

    public void with(T val, ThrowingRunnable tr) throws Exception {
        Object curr = this.local.get();
        if (this.coalescer == null) {
            throw new IllegalStateException("Already set to " + curr);
        }
        T nue = curr == null ? val : this.coalescer.apply(curr, val);
        try (QuietAutoCloseable outer = this.local.set(nue);){
            tr.run();
        }
    }
}

