/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.preconditions;

import com.mastfrog.util.preconditions.InvalidArgumentException;
import com.mastfrog.util.preconditions.NullArgumentException;
import java.io.File;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class Checks {
    static boolean disabled = Boolean.getBoolean("checksDisabled");
    private static final LinkOption[] NO_OPTS = new LinkOption[0];

    private Checks() {
    }

    public static void notSame(String a, String b, Object oa, Object ob) {
        if (oa == ob) {
            throw new InvalidArgumentException(a + " must not be the same object as " + b + " but was passed " + oa);
        }
    }

    public static String isDigits(String name, String value) {
        if (disabled) {
            return value;
        }
        if (name == null) {
            name = value;
        }
        Checks.notNull(name, value);
        int max = value.length();
        for (int i = 0; i < max; ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c)) continue;
            throw new InvalidArgumentException(name + " contains '" + c + "' (0x" + Integer.toHexString(c) + ") which cannot be parsed as an integer: " + value);
        }
        return value;
    }

    public static long canCastToInt(String name, long value) {
        if (disabled) {
            return value;
        }
        if (value > Integer.MAX_VALUE) {
            throw new InvalidArgumentException(name + " too large for an integer: " + value);
        }
        if (value < Integer.MIN_VALUE) {
            throw new InvalidArgumentException(name + " too small for an integer: " + value);
        }
        return value;
    }

    public static void atLeastOneNotNull(String msg, Object ... objects) {
        if (disabled) {
            return;
        }
        boolean foundNonNull = false;
        for (Object o : objects) {
            if (o == null) continue;
            foundNonNull = true;
            break;
        }
        if (!foundNonNull) {
            throw new NullArgumentException(msg);
        }
    }

    public static <T> T notNull(String name, T val) {
        if (disabled) {
            return val;
        }
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        if (val == null) {
            throw new NullArgumentException(name + " is null");
        }
        return val;
    }

    public static <T extends Number> T nonNegative(String name, T val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val.longValue() < 0L) {
            throw new InvalidArgumentException(name + " cannot be a negative number but is " + val);
        }
        return val;
    }

    public static int nonNegative(String name, int val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val < 0) {
            throw new InvalidArgumentException(name + " cannot be a negative number but is " + val);
        }
        return val;
    }

    public static long nonNegative(String name, long val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val < 0L) {
            throw new InvalidArgumentException(name + " cannot be a negative number but is " + val);
        }
        return val;
    }

    public static <T extends Number> T greaterThanOne(String name, T val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val.longValue() < 1L) {
            throw new InvalidArgumentException(name + " cannot be < 1 but is " + val);
        }
        return val;
    }

    public static int greaterThanOne(String name, int val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val < 1) {
            throw new InvalidArgumentException(name + " cannot be < 1 but is " + val);
        }
        return val;
    }

    public static long greaterThanOne(String name, long val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val < 1L) {
            throw new InvalidArgumentException(name + " cannot be < 1 but is " + val);
        }
        return val;
    }

    public static <T extends Number> T greaterThanZero(String name, T val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val.longValue() < 1L || val.doubleValue() < 1.0) {
            throw new InvalidArgumentException(name + " cannot be < 1 but is " + val);
        }
        return val;
    }

    public static int greaterThanZero(String name, int val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val < 1) {
            throw new InvalidArgumentException(name + " cannot be < 1 but is " + val);
        }
        return val;
    }

    public static long greaterThanZero(String name, long val) {
        if (disabled) {
            return val;
        }
        Checks.notNull("name", name);
        if (val < 1L) {
            throw new InvalidArgumentException(name + " cannot be < 1 but is " + val);
        }
        return val;
    }

    public static <T> T notEmptyOrNull(String name, T array) {
        if (disabled) {
            return array;
        }
        Checks.notNull(name, array);
        Class<?> arrType = array.getClass();
        if (!arrType.isArray()) {
            throw new InvalidArgumentException("Not an array: " + array);
        }
        if (Array.getLength(array) == 0) {
            throw new InvalidArgumentException(name + " has 0 length");
        }
        return array;
    }

    @SafeVarargs
    public static <T> T[] noNullElements(String name, T ... arr) {
        if (disabled) {
            return arr;
        }
        Checks.notNull(name, arr);
        Class<?> arrType = arr.getClass();
        if (arrType.getComponentType().isPrimitive()) {
            throw new InvalidArgumentException("Null checks not needed for primitive arrays such as " + name + " (" + arrType.getComponentType() + ")");
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != null) continue;
            throw new NullArgumentException("Null element at " + i + " in " + name + " (" + Arrays.asList(arr) + ")");
        }
        return arr;
    }

    public static <T extends Number> T nonZero(String name, T val) {
        if (disabled) {
            return val;
        }
        Checks.notNull(name, val);
        if (val.longValue() == 0L) {
            throw new IllegalStateException(name + " should not be 0");
        }
        return val;
    }

    public static int nonZero(String name, int val) {
        if (disabled) {
            return val;
        }
        if (val == 0) {
            throw new IllegalStateException(name + " should not be 0");
        }
        return val;
    }

    public static long nonZero(String name, long val) {
        if (disabled) {
            return val;
        }
        if (val == 0L) {
            throw new IllegalStateException(name + " should not be 0");
        }
        return val;
    }

    public static <T extends CharSequence> T notEmpty(String name, T value) {
        if (disabled) {
            return value;
        }
        Checks.notNull("name", name);
        if (value instanceof String && ((String)value).isEmpty()) {
            throw new InvalidArgumentException("String " + name + " cannot be 0-length");
        }
        if (value != null && value.length() == 0) {
            throw new InvalidArgumentException("String " + name + " cannot be 0-length");
        }
        return value;
    }

    public static void notEmpty(String name, Collection<?> collection) {
        if (disabled) {
            return;
        }
        if (collection != null && collection.isEmpty()) {
            throw new InvalidArgumentException(name + " cannot be an empty collection (" + collection + ")");
        }
    }

    public static <T extends CharSequence> T notNullOrEmpty(String name, T value) {
        if (disabled) {
            return value;
        }
        Checks.notNull(name, value);
        return Checks.notEmpty(name, value);
    }

    public static void mayNotContain(String name, CharSequence value, char ... chars) {
        if (disabled) {
            return;
        }
        Checks.notNull("chars", chars);
        if (value == null) {
            return;
        }
        if (chars.length == 0) {
            throw new InvalidArgumentException("0 length list of characters");
        }
        if (chars.length == 1) {
            int index = Checks.indexIn(value, chars[0]);
            if (index > 0) {
                throw new InvalidArgumentException("Illegal character at " + index + " in " + value);
            }
        } else {
            for (char c : chars) {
                int index = Checks.indexIn(value, chars[0]);
                if (index <= 0) continue;
                throw new InvalidArgumentException("Illegal character " + c + "at " + index + " in " + value);
            }
        }
    }

    private static int indexIn(CharSequence seq, char c) {
        if (seq instanceof String) {
            return ((String)seq).indexOf(c);
        }
        if (seq instanceof StringBuilder) {
            return ((StringBuilder)seq).indexOf("" + c);
        }
        int max = seq.length();
        for (int i = 0; i < max; ++i) {
            if (c != seq.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static void mustContain(String name, CharSequence value, char c) {
        if (disabled) {
            return;
        }
        if (value != null && Checks.indexIn(value, c) < 0) {
            throw new InvalidArgumentException(name + " must contain a '" + c + "' character but does not (" + value + ")");
        }
    }

    public static void noDuplicates(String name, Collection<?> collection) {
        HashSet nue;
        if (disabled) {
            return;
        }
        if (!(collection instanceof Set) && (nue = new HashSet(collection)).size() != collection.size()) {
            throw new InvalidArgumentException(name + " contains duplicate entries (" + collection + ")");
        }
    }

    public static void mayNotStartWith(String name, CharSequence value, char c) {
        if (disabled) {
            return;
        }
        if (value != null && value.length() > 0 && c == value.charAt(0)) {
            throw new InvalidArgumentException(name + " may not start with a '" + c + "' character (" + value + ")");
        }
    }

    public static void isInstance(String name, Class<?> type, Object value) {
        if (disabled) {
            return;
        }
        if (value != null && !type.isInstance(value)) {
            throw new ClassCastException(value + " is not an instance of " + type.getName() + " (" + value.getClass().getName() + ")");
        }
    }

    public static void isOfLength(String name, int length, Object[] value) {
        if (disabled) {
            return;
        }
        Checks.notNull(name, value);
        if (value.length != length) {
            throw new InvalidArgumentException("value " + Objects.toString(value) + " does not have the required arguments of " + length);
        }
    }

    public static void fileExists(File file) {
        if (disabled) {
            return;
        }
        Checks.notNull("file", file);
        if (!file.exists() || !file.isFile()) {
            throw new InvalidArgumentException(file + " does not exist or is not a regular file");
        }
    }

    public static Path exists(Path file) {
        if (disabled) {
            return file;
        }
        return Checks.exists(Objects.toString(file), file);
    }

    public static Path exists(String paramName, Path file) {
        if (disabled) {
            return file;
        }
        if (!Files.exists(Checks.notNull(paramName, file), new LinkOption[0])) {
            throw new InvalidArgumentException(paramName + " does not exist: " + file);
        }
        return file;
    }

    public static Path readable(Path file) {
        if (disabled) {
            return file;
        }
        return Checks.readable(Objects.toString(file), file);
    }

    public static Path readable(String paramName, Path file) {
        if (disabled) {
            return file;
        }
        if (!Files.isReadable(Checks.exists(paramName, Checks.notNull(paramName, file)))) {
            throw new InvalidArgumentException(file + " not readable");
        }
        return file;
    }

    public static Path regularFile(Path file) {
        if (disabled) {
            return file;
        }
        return Checks.regularFile(file, NO_OPTS);
    }

    public static Path regularFile(Path file, LinkOption ... opts) {
        if (disabled) {
            return file;
        }
        return Checks.regularFile(Objects.toString(file), file, opts);
    }

    public static Path regularFile(String paramName, Path file, LinkOption ... opts) {
        if (disabled) {
            return file;
        }
        Checks.notNull("file", file);
        Checks.exists(file);
        if (!Files.isRegularFile(file, opts)) {
            throw new InvalidArgumentException(file + " not readable");
        }
        return file;
    }

    public static Path writable(Path file) {
        if (disabled) {
            return file;
        }
        return Checks.writable(Objects.toString(file), file);
    }

    public static Path writable(String paramName, Path file) {
        if (disabled) {
            return file;
        }
        Checks.notNull("file", file);
        Checks.exists(file);
        if (!Files.isWritable(file)) {
            throw new InvalidArgumentException(paramName + " not writable: " + file);
        }
        return file;
    }

    public static Path executable(Path file) {
        if (disabled) {
            return file;
        }
        return Checks.executable(Objects.toString(file), file);
    }

    public static Path executable(String paramName, Path file) {
        if (disabled) {
            return file;
        }
        Checks.notNull(paramName, file);
        Checks.exists(file);
        if (!Files.isExecutable(file)) {
            throw new InvalidArgumentException(paramName + " not executable: " + file);
        }
        return file;
    }

    public static Path fileExists(Path file) {
        if (disabled) {
            return file;
        }
        return Checks.fileExists(Objects.toString(file), file);
    }

    public static Path fileExists(String paramName, Path file) {
        if (disabled) {
            return file;
        }
        Checks.notNull(paramName, file);
        Checks.exists(paramName, file);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new InvalidArgumentException(paramName + " does not exist or is not a regular file: " + file);
        }
        return file;
    }

    public static Path folderExists(String paramName, Path file) {
        if (disabled) {
            return file;
        }
        Checks.notNull(paramName, file);
        Checks.exists(paramName, file);
        if (!Files.exists(file, new LinkOption[0]) || !Files.isDirectory(file, new LinkOption[0])) {
            throw new InvalidArgumentException(file + " does not exist or is not a folder");
        }
        return file;
    }

    public static File fileExists(String paramName, File file) {
        if (disabled) {
            return file;
        }
        Checks.notNull(paramName, file);
        if (!file.exists() || !file.isFile()) {
            throw new InvalidArgumentException(paramName + " does not exist or is not a regular file: " + file);
        }
        return file;
    }

    public static void folderExists(File file) {
        if (disabled) {
            return;
        }
        Checks.notNull("file", file);
        if (!file.exists() || !file.isDirectory()) {
            throw new InvalidArgumentException(file + " does not exist or is not a regular file");
        }
    }

    public static File folderExists(String paramName, File file) {
        if (disabled) {
            return file;
        }
        Checks.notNull(paramName, file);
        Path pth = file.toPath();
        if (!file.exists()) {
            throw new InvalidArgumentException(paramName + " does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new InvalidArgumentException(paramName + " is not a directory: " + file);
        }
        return file;
    }

    public static void readable(File file) {
        if (disabled) {
            return;
        }
        Checks.fileExists(file);
        if (!file.canRead()) {
            throw new InvalidArgumentException("Read permission missing on " + file);
        }
    }

    public static File readable(String paramName, File file) {
        if (disabled) {
            return file;
        }
        Checks.fileExists(paramName, file);
        if (!file.canRead()) {
            throw new InvalidArgumentException(paramName + " exists and is a file but is not readable: " + file);
        }
        return file;
    }

    public static File readableAndNonZeroLength(String paramName, File file) {
        if (disabled) {
            return file;
        }
        if (Checks.readable(paramName, file).length() == 0L) {
            throw new InvalidArgumentException(paramName + " exists and is a file but is not readable: " + file);
        }
        return file;
    }

    public static void encodable(CharSequence seq, Charset charset) {
        if (disabled) {
            return;
        }
        Checks.notNull("seq", seq);
        Checks.notNull("charset", charset);
        CharsetEncoder encoder = charset.newEncoder();
        if (!encoder.canEncode(seq)) {
            if (seq.length() > 30) {
                seq = seq.subSequence(0, 30) + "...";
            }
            throw new InvalidArgumentException("Cannot be encoded in " + charset.name() + " '" + seq + "'");
        }
    }
}

